% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{calBP.14C}
\alias{calBP.14C}
\title{Find the 14C age and error belonging to a cal BP age.}
\usage{
calBP.14C(
  yr,
  cc = 1,
  cc1 = "IntCal13.14C",
  cc2 = "Marine13.14C",
  cc3 = "SHCal13.14C",
  cc4 = "mixed.14C",
  ccdir = "",
  postbomb = FALSE,
  pb1 = "postbomb_NH1.14C",
  pb2 = "postbomb_NH2.14C",
  pb3 = "postbomb_NH3.14C",
  pb4 = "postbomb_SH1-2.14C",
  pb5 = "postbomb_SH3.14C"
)
}
\arguments{
\item{yr}{The cal BP year.}

\item{cc}{calibration curve for C14 dates (1, 2 or 3).}

\item{cc1}{For northern hemisphere terrestrial C14 dates.}

\item{cc2}{For marine C14 dates.}

\item{cc3}{For southern hemisphere C14 dates.}

\item{cc4}{A custom calibration curve}

\item{ccdir}{Directory where the calibration curves for C14 dates \code{cc} are allocated. By default \code{ccdir=""}. 
Use \code{ccdir="."} to choose current working directory. Use \code{ccdir="Curves/"} to choose sub-folder \code{Curves/}.}

\item{postbomb}{Which postbomb curve to use for negative 14C dates}

\item{pb1}{For Northern hemisphere region 1 postbomb C-14 dates.}

\item{pb2}{For Northern hemisphere region 2 postbomb C-14 dates.}

\item{pb3}{For Northern hemisphere region 3 postbomb C-14 dates.}

\item{pb4}{For Southern hemisphere regions 1-2 postbomb C-14 dates.}

\item{pb5}{For Southern hemisphere region 3 postbomb C-14 dates.}
}
\description{
From a given calendar ages, the calibration curve (default cc=1) is interpolated and the corresponding 14C age and error is returned.
}
\details{
Interpolation is used, and values outside the calibration curve are given as NA. For negative cal BP ages, a postbomb curve will have to be provided.
}
\examples{
calBP.14C(100) 

}
\author{
Maarten Blaauw
}
