% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_not_false}
\alias{is_not_false}
\title{Test if an Object is not False}
\usage{
is_not_false(object, null_is_false = TRUE, ...)
}
\arguments{
\item{object}{The object to be tested.}

\item{null_is_false}{[boolean(1)]\cr Should NULL be treated as FALSE?}

\item{...}{Parameters passed to \code{\link{exists}}. See Details and
Examples.}
}
\value{
TRUE if the object is set to something different than FALSE, FALSE
otherwise.
}
\description{
Sometimes you need to know whether or not an object exists and is not set to
FALSE (and possibly not NULL).
}
\details{
Pass an environment if you call the function elsewhere than from
\code{\link{.GlobalEnv}}.
}
\examples{
a  <- 1
is_not_false(a)
f <- function() {
    a <- NULL
    should_be_true <- ! is_not_false(a, null_is_false = TRUE, 
                                      where = environment())
    return(should_be_true)
}
print(f())
}
\author{
Andreas Dominik Cullmann, <adc-r@arcor.de>
}

