% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures_pairs.R
\name{accuracy_pairs}
\alias{accuracy_pairs}
\title{Accuracy of Linked Pairs}
\usage{
accuracy_pairs(true_pairs, pred_pairs, num_pairs, ordered = FALSE)
}
\arguments{
\item{true_pairs}{set of true coreferent pairs stored in a matrix or
data.frame, where rows index pairs and columns index the ids of the
constituents. Any pairs not included are assumed to be \emph{non-coreferent}.
Duplicate pairs (including equivalent pairs with reversed ids) are
automatically removed.}

\item{pred_pairs}{set of predicted coreferent pairs, following the same
specification as \code{true_pairs}.}

\item{num_pairs}{the total number of coreferent and non-coreferent pairs,
excluding equivalent pairs with reversed ids.}

\item{ordered}{whether to treat the element pairs as ordered---i.e. whether
pair \eqn{(x, y)} is distinct from pair \eqn{(y, x)} for \eqn{x \neq y}.
Defaults to FALSE, which is appropriate for clustering, undirected link
prediction, record linkage etc.}
}
\description{
Computes the accuracy of a set of \emph{predicted} coreferent
(linked) pairs given a set of \emph{ground truth} coreferent pairs.
}
\details{
The accuracy is defined as:
\deqn{\frac{|T \cup P| + |T' \cup P'|}{N}}{(|T ∩ P| + |T' ∩ P'|)/N}
  where:
\itemize{
\item \eqn{T} is the set of true coreferent pairs,
\item \eqn{P} is the set of predicted coreferent pairs,
\item \eqn{T'} is the set of true non-coreferent pairs,
\item \eqn{P'} is the set of predicted non-coreferent pairs, and
\item \eqn{N} is the total number of coreferent and non-coreferent pairs.
}
}
\examples{
true_pairs <- rbind(c(1,2), c(2,3), c(1,3)) # ground truth is 3-clique
pred_pairs <- rbind(c(1,2), c(2,3))         # prediction misses one edge
num_pairs <- 3                              # assuming 3 elements
accuracy_pairs(true_pairs, pred_pairs, num_pairs)

}
