% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteo_ogimet.R
\name{meteo_ogimet}
\alias{meteo_ogimet}
\title{Scrapping meteorological (Synop) data from the Ogimet webpage}
\usage{
meteo_ogimet(interval, date, coords = FALSE, station, precip_split = TRUE)
}
\arguments{
\item{interval}{'daily' or 'hourly' dataset to retrieve - given as character}

\item{date}{start and finish date (e.g., date = c("2018-05-01", "2018-07-01")) - character or Date class object}

\item{coords}{add geographical coordinates of the station (logical value TRUE or FALSE)}

\item{station}{WMO ID of meteorological station(s). Character or numeric vector}

\item{precip_split}{whether to split precipitation fields into 6/12/24h
numeric fields (logical value TRUE (default) or FALSE); valid only for hourly time step}
}
\value{
A data.frame with columns describing the synoptic parameters (e.g. air temperature, wind speed, cloudines) where each row represent a measurement,
depending on the interval, at a given hour or day.
}
\description{
Downloading hourly or daily (meteorological) data from the Synop stations available at https://www.ogimet.com/
}
\examples{
\donttest{
  # downloading data for Poznan-Lawica
  poznan <- meteo_ogimet(interval = "daily", date = c("2019-06-01", "2019-07-08"),
                   station = 12330, coords = TRUE)
  head(poznan)
}

}
