#' Example of input data using local data
#' 
#' Input example from disk data. See details
#' 
#' @details 
#' 
#' \code{temp_dat}: array with two layers 1) day temperature and 2) night temperature. 
#'  An excerpt of MODIS (MYD11A1) data to represent an example 
#'  of the input data in \code{temperature()} and \code{get_timeseries()} 
#'  when an array is provided.
#' 
#' \code{rain_dat}: matrix with precipitation from CHIRPS. An excerpt to represent 
#'  an example of the input data in \code{rainfall()} or 
#'  \code{get_timeseries()} when a matrix is provided.
#'  
#' \code{innlandet}: a data.frame with maximum and minimum temperature for a random point in 
#'  the Innlandet county in Norway, spanning from "2019-01-01" to "2019-07-01"
#'  
#' \code{lonlatsf}: a 'sf' object with 'POINT' geometry with five random points around 
#'  the municipality of Sinop, Brazil 
#'  
#' In \code{temp_dat} and \code{rain_dat}, rows represents the coordinates for the 
#'  given lonlat provided in \code{raster::extract()} and colunms represents the dates 
#'  from the observed precipitation/temperature.
#' 
#' @name clima_data
#' @rdname clima_data
#' @docType data
#' @aliases lonlatsf
#' @aliases temp_dat
#' @aliases rain_dat
#' @aliases innlandet
#' @keywords datasets
#' @source 
#' 
#' Funk, C. et al. (2015). The climate hazards infrared precipitation 
#' with stations—a new environmental record for monitoring extremes. 
#' Scientific Data, 2, 150066. \doi{https://doi.org/10.1038/sdata.2015.66}
#' 
#' Wan Z, Hook S, Hulley G (2015) MYD11A1 MODIS/Aqua Land Surface 
#' Temperature/Emissivity 8-Day L3 Global 1km
#' SIN Grid V006 \doi{http://doi.org/10.5067/MODIS/MYD11A2.006}.
#' 
#' @format 
#' an array with two layers (temp_dat) a matrix (rain_dat),
#'  a data.frame (innlandet), a sf object (lonlatsf)
c("rain_dat", "temp_dat", "lonlatsf","innlandet")

