\name{print.emaxsimobj}
\alias{print.emaxsimobj}

\title{Print a data set generated by emaxsim }
\description{
  Print a data set that has been extracted from emaxsim output
}
\usage{
\method{print}{emaxsimobj}(x, nprint = min(length(x$y), 20), ...)
}

\arguments{
  \item{x}{ Extracted simulation object }
  \item{nprint}{ Number of observations to print.  If a vector of
length 2, \code{nprint} is the range of data to print. }
  \item{...}{No other parameters currently implemented}
}

\value{
Printed output returned as invisible matrix.
}

\author{ Neal Thomas }

\seealso{ \code{\link{emaxsim}}, 
\code{\link{plot.emaxsimobj}}, \code{\link{summary.emaxsimobj}} }
\examples{

\dontrun{

save.seed<-.Random.seed
set.seed(12357)

nsim<-50
idmax<-5
doselev<-c(0,5,25,50,100)
n<-c(78,81,81,81,77)

### population parameters for simulation
e0<-2.465375 
ed50<-67.481113 
emax<-15.127726
sdy<-7.967897
pop<-c(log(ed50),emax,e0)    
meanlev<-emaxfun(doselev,pop)  

###FixedMean is specialized constructor function for emaxsim
gen.parm<-FixedMean(n,doselev,meanlev,sdy)  
D1 <- emaxsim(nsim,gen.parm)
e49<-D1[49]

e49

print(e49,c(101,200))  

.Random.seed<-save.seed
}
}
\keyword{nonlinear }

