% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-palettes.R
\name{getShapePalette}
\alias{getShapePalette}
\title{Get a shape palette for clinical
visualizations.}
\usage{
getShapePalette(
  n = NULL,
  x = NULL,
  includeNA = FALSE,
  asText = FALSE,
  palette = if (asText) {     clinShapesText } else {     clinShapes }
)
}
\arguments{
\item{n}{Integer of length 1, number of elements in palette.}

\item{x}{Vector with elements used for palette.
If factor, the levels are used, otherwise the unique elements of the vector.
Missing values are automatically removed, excepted if
\code{includeNA} is set to TRUE.}

\item{includeNA}{Logical (FALSE by default), 
should NA elements be retained in the palette in case
\code{x} is specified?}

\item{asText}{Logical (FALSE by default), should the palette
be expressed as integer (base R plot and ggplot2 compatible)
or in text format 
(e.g. required if combined with unicode symbols in ggplot2)?}

\item{palette}{A vector of custom shapes,
or a function returning this vector from a specific
number of shapes.\cr
The vector should be a character if \code{asText} is set to TRUE.\cr
Default is the \code{\link{clinShapes}} shape palette,
or \code{\link{clinShapesText}} if \code{asText} is set to TRUE.}
}
\value{
Vector of shapes,
named with the elements in \code{x} if \code{x} is specified.
}
\description{
Get a shape palette of specified length,
either from a vector of names for the palette, or
from a specified length.
}
\details{
Note that 19 unique symbols are available at maximum
(replicated if necessary).
}
\examples{
#' extract longest shape palette available
getShapePalette(n = 19)
# extract palette for a vector
getShapePalette(x = paste('treatment', 1:4))
# include missing
getShapePalette(x = c(NA_character_, "group1"), includeNA = TRUE)
getShapePalette(x = c(NA_character_, "group1"), includeNA = FALSE)
# change default settings
getShapePalette(x = paste('treatment', 1:3), palette = c("circle", "triangle"))
# get symbols as 'text' (e.g. to be combined with Unicode in ggplot2)
getShapePalette(x = paste('treatment', 1:4), asText = TRUE)
}
\author{
Laure Cougnaud and Michela Pasetto
}
