% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_polygenic.R
\name{trans_polygenic}
\alias{trans_polygenic}
\title{The transmission matrix for the hypergeometric polygenic model}
\usage{
trans_polygenic(n_loci, annotate = FALSE)
}
\arguments{
\item{n_loci}{A positive integer, interpreted as the number of biallelic
genetic loci that contribute to the polygene.  The polygene will have
\code{2*n_loci + 1} genotypes, so \code{n_loci} is typically fairly small, e.g. \code{4}.}

\item{annotate}{A logical flag. When \code{FALSE} (the default), the function
returns a matrix suitable to be used as the \code{trans} argument of
\code{\link{pedigree_loglikelihood}}. When \code{TRUE}, the function annotates
this matrix (and converts it to a data frame) to make the output more
easily understood by humans.}
}
\value{
Either a matrix of genetic transmission probabilities suitable to be
used as the \code{trans} argument of \code{\link{pedigree_loglikelihood}}
(if \code{annotate} is \code{FALSE}), or a data frame that is an annotated version of
this matrix (if \code{annotate} is \code{TRUE}).
}
\description{
A function to calculate the transmission matrix for the hypergeometric
polygenic model of (Cannings et al., 1978), see also Section 8.9 of
(Lange, 2002) for a nice description of this model.
}
\details{
This function calculates the genetic transmission probabilities
(i.e. the conditional probability of a person's genotype, given his
or her biological parents' genotypes) for the hypergeometric polygenic model,
which is described in \code{\link{geno_freq_polygenic}}.

When \code{annotate} is \code{FALSE},
a matrix of transmission probabilities is returned, with rows
corresponding to the possible joint parental genotypes and columns
corresponding to the possible offspring genotypes.
Setting \code{annotate} to \code{TRUE} shows which rows and columns correspond to
which genotypes,  by adding offspring genotypes as column names and adding
columns \code{gm} and \code{gf} containing (respectively) the mother's and father's
genotypes. Note that if the output of this function is to be used as the \code{trans}
argument of \code{\link{pedigree_loglikelihood}} then the \code{annotate} option
must be set to \code{FALSE}.
}
\examples{
trans_polygenic(4, annotate = TRUE)
apply(trans_polygenic(4), 1, sum)

}
\references{
Cannings C, Thompson E, Skolnick M. Probability functions
on complex pedigrees. Advances in Applied Probability, 1978;10(1):26-61.

Lange K.  Mathematical and Statistical Methods for Genetic Analysis
(second edition). Springer, New York. 2002.
}
