% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posixt.R
\name{posixt-getters}
\alias{posixt-getters}
\alias{get_year.POSIXt}
\alias{get_month.POSIXt}
\alias{get_day.POSIXt}
\alias{get_hour.POSIXt}
\alias{get_minute.POSIXt}
\alias{get_second.POSIXt}
\title{Getters: date-time}
\usage{
\method{get_year}{POSIXt}(x)

\method{get_month}{POSIXt}(x)

\method{get_day}{POSIXt}(x)

\method{get_hour}{POSIXt}(x)

\method{get_minute}{POSIXt}(x)

\method{get_second}{POSIXt}(x)
}
\arguments{
\item{x}{\verb{[POSIXct / POSIXlt]}

A date-time type to get the component from.}
}
\value{
The component.
}
\description{
These are POSIXct/POSIXlt methods for the \link[=clock-getters]{getter generics}.
\itemize{
\item \code{get_year()} returns the Gregorian year.
\item \code{get_month()} returns the month of the year.
\item \code{get_day()} returns the day of the month.
\item There are sub-daily getters for extracting more precise components, up to
a precision of seconds.
}

For more advanced component extraction, convert to the calendar type
that you are interested in.
}
\examples{
x <- as.POSIXct("2019-01-01", tz = "America/New_York")

x <- add_days(x, 0:5)
x <- set_second(x, 10:15)

get_day(x)
get_second(x)
}
