/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.simpleworkflow.model.RegisterActivityTypeRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterActivityTypeRequestMarshaller
implements Marshaller<Request<RegisterActivityTypeRequest>, RegisterActivityTypeRequest> {
    @Override
    public Request<RegisterActivityTypeRequest> marshall(RegisterActivityTypeRequest registerActivityTypeRequest) {
        if (registerActivityTypeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterActivityTypeRequest> request = new DefaultRequest<RegisterActivityTypeRequest>(registerActivityTypeRequest, "AmazonSimpleWorkflow");
        String target = "SimpleWorkflowService.RegisterActivityType";
        request.addHeader("X-Amz-Target", target);
        request.addHeader("Content-Type", "application/x-amz-json-1.0");
        request.setHttpMethod(HttpMethodName.POST);
        try {
            TaskList defaultTaskList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (registerActivityTypeRequest.getDomain() != null) {
                jsonWriter.key("domain").value(registerActivityTypeRequest.getDomain());
            }
            if (registerActivityTypeRequest.getName() != null) {
                jsonWriter.key("name").value(registerActivityTypeRequest.getName());
            }
            if (registerActivityTypeRequest.getVersion() != null) {
                jsonWriter.key("version").value(registerActivityTypeRequest.getVersion());
            }
            if (registerActivityTypeRequest.getDescription() != null) {
                jsonWriter.key("description").value(registerActivityTypeRequest.getDescription());
            }
            if (registerActivityTypeRequest.getDefaultTaskStartToCloseTimeout() != null) {
                jsonWriter.key("defaultTaskStartToCloseTimeout").value(registerActivityTypeRequest.getDefaultTaskStartToCloseTimeout());
            }
            if (registerActivityTypeRequest.getDefaultTaskHeartbeatTimeout() != null) {
                jsonWriter.key("defaultTaskHeartbeatTimeout").value(registerActivityTypeRequest.getDefaultTaskHeartbeatTimeout());
            }
            if ((defaultTaskList = registerActivityTypeRequest.getDefaultTaskList()) != null) {
                jsonWriter.key("defaultTaskList").object();
                if (defaultTaskList.getName() != null) {
                    jsonWriter.key("name").value(defaultTaskList.getName());
                }
                jsonWriter.endObject();
            }
            if (registerActivityTypeRequest.getDefaultTaskScheduleToStartTimeout() != null) {
                jsonWriter.key("defaultTaskScheduleToStartTimeout").value(registerActivityTypeRequest.getDefaultTaskScheduleToStartTimeout());
            }
            if (registerActivityTypeRequest.getDefaultTaskScheduleToCloseTimeout() != null) {
                jsonWriter.key("defaultTaskScheduleToCloseTimeout").value(registerActivityTypeRequest.getDefaultTaskScheduleToCloseTimeout());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes("UTF-8");
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            return request;
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }
}

