% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cb_filter_apply.R
\name{cb_apply_query}
\alias{cb_apply_query}
\title{Apply a query to a cohort}
\usage{
cb_apply_query(cohort, query, keep_query = TRUE)
}
\arguments{
\item{cohort}{A cohort object. (Required)
See constructor function \code{\link{cb_create_cohort}} or \code{\link{cb_load_cohort}}}

\item{query}{A phenotype query defined using the \code{\link{phenotype}} function and logic operators (see example below)}

\item{keep_query}{If True, combines the newly supplied query with the pre-existing query.
Otherwise, pre-existing query is overwritten. (Default: TRUE)}
}
\value{
The updated cohort object.
}
\description{
Updates a cohort by applying a new query.
}
\examples{
\dontrun{
A <- phenotype(id = 13, from = "2016-01-21", to = "2017-02-13")
B <- phenotype(id = 4, value = "Cancer")

A_not_B <- A & !B

my_cohort <- cb_load_cohort(cohort_id = "612f37a57673ed0ddeaf1333", cb_version = "v2")

my_cohort <- cb_apply_query(my_cohort, query = A_not_B, keep_query = F)
}

}
