% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm.R
\name{vcovCR.glm}
\alias{vcovCR.glm}
\title{Cluster-robust variance-covariance matrix for a glm object.}
\usage{
\method{vcovCR}{glm}(
  obj,
  cluster,
  type,
  target = NULL,
  inverse_var = NULL,
  form = "sandwich",
  ...
)
}
\arguments{
\item{obj}{Fitted model for which to calculate the variance-covariance matrix}

\item{cluster}{Expression or vector indicating which observations belong to
the same cluster. Required for \code{glm} objects.}

\item{type}{Character string specifying which small-sample adjustment should 
be used, with available options \code{"CR0"}, \code{"CR1"}, \code{"CR1p"},
\code{"CR1S"}, \code{"CR2"}, or \code{"CR3"}. See "Details" section of 
\code{\link{vcovCR}} for further information.}

\item{target}{Optional matrix or vector describing the working
variance-covariance model used to calculate the \code{CR2} and \code{CR4}
adjustment matrices. If a vector, the target matrix is assumed to be
diagonal. If not specified, the target is taken to be the estimated variance function.}

\item{inverse_var}{Optional logical indicating whether the weights used in 
fitting the model are inverse-variance. If not specified, \code{vcovCR} 
will attempt to infer a value.}

\item{form}{Controls the form of the returned matrix. The default 
\code{"sandwich"} will return the sandwich variance-covariance matrix. 
Alternately, setting \code{form = "meat"} will return only the meat of the 
sandwich and setting \code{form = B}, where \code{B} is a matrix of 
appropriate dimension, will return the sandwich variance-covariance matrix 
calculated using \code{B} as the bread. \code{form = "estfun"} will return the 
(appropriately scaled) estimating function, the transposed crossproduct of 
which is equal to the sandwich variance-covariance matrix.}

\item{...}{Additional arguments available for some classes of objects.}
}
\value{
An object of class \code{c("vcovCR","clubSandwich")}, which consists
  of a matrix of the estimated variance of and covariances between the
  regression coefficient estimates.
}
\description{
\code{vcovCR} returns a sandwich estimate of the variance-covariance matrix 
of a set of regression coefficient estimates from an \code{\link{glm}} object.
}
\examples{

data(dietox, package = "geepack")
dietox$Cu <- as.factor(dietox$Cu)
weight_fit <- glm(Weight ~ Cu * poly(Time, 3), data=dietox, family = "quasipoisson")
V_CR <- vcovCR(weight_fit, cluster = dietox$Pig, type = "CR2")
coef_test(weight_fit, vcov = V_CR, test = "Satterthwaite")

}
\seealso{
\code{\link{vcovCR}}
}
