% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/special.R
\name{group}
\alias{group}
\title{Identify treatment groups.}
\usage{
group(x)
}
\arguments{
\item{x}{A numeric variable of cluster id.}
}
\description{
This is a special function used in the context of formula
used for Wilcoxon sum rank test for clustered data.
It identifies the treatment group id of observations, and is used
on the right hand side of a formula.
}
\details{
The only action of this function is semantic, to mark
a variable as the group indicator. Must be supplied.
}
\examples{
data(crd)
cluswilcox.test(z ~ cluster(id) + group(group), data = crd)
}
\seealso{
\code{\link{cluswilcox.test.formula}}
}
\keyword{internal}

