% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise.clusWilcox.test.R
\name{pairwise.clusWilcox.test}
\alias{pairwise.clusWilcox.test}
\title{Pairwise Wilcoxon Rank Sum and Signed Rank Tests for Clustered Data}
\usage{
pairwise.clusWilcox.test(
  x,
  group,
  cluster,
  p.adjust.method = p.adjust.methods,
  ...
)
}
\arguments{
\item{x}{A numeric vector of data values.}

\item{group}{An optional numeric vector of treatment id.}

\item{cluster}{An optional numeric vector of cluster id.}

\item{p.adjust.method}{Method for adjusting p values.  \code{?p.adjust} for
details.}

\item{...}{Other arguments passed to \code{clusWilcox.test}.}
}
\value{
A \code{pairwise.htest} object.
}
\description{
Performs pairwise comparisons between group levels with corrections for
multiple testing.
}
\examples{
library(clusrank)
data(crd)

## for demonstration purpose, create random groups
set.seed(123)
g <- sample(seq_len(3), size = nrow(crd), replace = TRUE)
with(crd, pairwise.clusWilcox.test(z, group = g, cluster = id,
                                   method = "ds", p.adjust.method = "fdr"))
}
