% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmr.R
\name{cmr}
\alias{cmr}
\title{Bayesian analysis of cardiovascular magnetic resonance imaging}
\usage{
cmr(
  data,
  input,
  mask = NULL,
  method = "spatial",
  quantiles = c(0.25, 0.75),
  cores = parallel::detectCores()
)
}
\arguments{
\item{data}{3D or 4D array of CMR signal}

\item{input}{input function}

\item{mask}{2d array of mask. Voxel with 0 or FALSE will be omitted from analysis. Default NULL: use NA values in data as mask}

\item{method}{"spatial" or "local"}

\item{quantiles}{quantiles used for credible interval, default: c(0.25, 0.75)}

\item{cores}{number of cores for parallel computation. Spatial model only computes slices parallel, local can be parallelized on voxel level}
}
\value{
list of mbf (point estimation) and ci (credible interval)
}
\description{
Bayesian analysis of cardiovascular magnetic resonance imaging
}
