% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nn.R
\name{nn}
\alias{nn}
\title{Nearest interpolation}
\usage{
nn(p, y, q)
}
\arguments{
\item{p}{matrix of variable values, each row is a data point}

\item{y}{vector of values, each entry corresponds to one row in \code{p}}

\item{q}{vector of variable values, each entry corresponds to one column of \code{p}}
}
\value{
an interpolated value for \var{q}
}
\description{
Find the nearest neighbor for a set of data points
}
\details{
\code{nn} finds the n-dimensional nearest neighbor for given datapoint
}
\examples{
p <- matrix(floor(runif(100, 0, 9)), 20)
y <- floor(runif(20, 0, 9))
q <- matrix(floor(runif(5, 0, 9)), 1)
nn(p, y, q)

}
\seealso{
Other interp: \code{\link{bezier}}, \code{\link{bilinear}},
  \code{\link{cubicspline}}, \code{\link{linterp}},
  \code{\link{polyinterp}}, \code{\link{pwiselinterp}}
}
