% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim.R
\name{cocoOptim}
\alias{cocoOptim}
\title{Optimizer for object class coco}
\usage{
cocoOptim(coco.object, boundaries = list(), 
ncores = parallel::detectCores(), optim.control, optim.type)
}
\arguments{
\item{coco.object}{a coco object. See ?coco()}

\item{boundaries}{if provided, a list with lower, init, and upper values.
if not is computed based on generic fast_init_boundaries()}

\item{ncores}{number of cores to be used for the optimization routine.}

\item{optim.control}{list with settings to be passed to the optimparallel function}

\item{optim.type}{Optimization approach: whether 'mle' for classical Maximum Likelihood approach,
or 'pmle' to factor out the spatial trend (when handling 'dense' coco objects), or
to factor out the global marginal standard deviation parameter (when considering 'sparse' coco objects)}
}
\value{
a fitted coco object
}
\description{
Optimizer based on multi-thread Optimparallel L-BFGS-B optimizers.
}
\details{
Current implementations only allow single realizations for 'pmle' optim.type.
}
\author{
Federico Blasi
}
