% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cocoreg.R
\name{mappings_R2_matrix}
\alias{mappings_R2_matrix}
\title{Extract R2 values from a list of mappings using summary()}
\usage{
mappings_R2_matrix(mappings, n_datasets, aggfun = mean)
}
\arguments{
\item{mappings}{[M*M-M] list, Exhaustive list of mappings between the M datasets}

\item{n_datasets}{integer, Number of datasets i.e. M}

\item{aggfun}{function, A function to apply when aggregating R2 values over variables in
a multivariate dataset}
}
\value{
A [M,M] matrix of R2 values stored such that the R2 value for mapping
         a->b is read from row a and column b.
}
\description{
Extract R2 values from a list of mappings using summary()
}
\examples{
\dontrun{
ccr <- cocoreg(data_collection)
R2mat <- mappings_R2_matrix(ccr$mappings, length(ccr$data))
}

}
