% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cointReg.R
\name{cointReg}
\alias{cointReg}
\title{Estimation and Inference for cointegrating regressions}
\usage{
cointReg(method = c("FM", "D", "IM"), x, y, ...)
}
\arguments{
\item{method}{[\code{character(1)}]\cr
Select the method for the estimation of your cointegration model:
\itemize{
  \item \code{"FM"}: FM-OLS (default), see details at \link{cointRegFM}
  \item \code{"D"}: D-OLS, see details at \link{cointRegD}
  \item \code{"IM"}: IM-OLS, see details at \link{cointRegIM}
}}

\item{x}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
RHS variables on which to apply the model estimation.}

\item{y}{[\code{numeric} | \code{matrix} | \code{data.frame}]\cr
LHS variable(s) on which to apply the model estimation.
Usually one-dimensional, but a \code{matrix} or
\code{data.frame} with more than one column is also possible
(only for FM-OLS).}

\item{...}{[\code{any}]\cr Arguments passed to the corresponding \code{cointReg} function,
like:
\itemize{
  \item \code{x}, \code{y}, \code{deter}: data to include in the model
  \item \code{kernel}, \code{bandwidth}: parameters for calculating the
        long-run variance
  \item \code{n.lead}, \code{n.lag}, \code{kmax}, \code{info.crit}:
        D-OLS specific arguments.
  \item \code{selector}, \code{t.test}: IM-OLS specific arguments.
  \item \code{check}: Wheather to check (and if necessary convert)
        the arguments. See \code{\link{checkVars}} for further information.
}}
}
\value{
[\code{cointReg}] object.
}
\description{
Computes either the Phillips and Hansen (1990) Fully Modified OLS estimator,
or the Saikkonen (1990) Dynamic OLS estimator, or the Vogelsang and Wagner
(2014) Integrated Modified OLS estimator.
}
\examples{
set.seed(1909)
x1 = cumsum(rnorm(100, mean = 0.05, sd = 0.1))
x2 = cumsum(rnorm(100, sd = 0.1)) + 1
x3 = cumsum(rnorm(100, sd = 0.2)) + 2
x = cbind(x1, x2, x3)
y = x1 + x2 + x3 + rnorm(100, sd = 0.2) + 1
deter = cbind(level = 1, trend = 1:100)
cointReg("FM", x = x, y = y, deter = deter, kernel = "ba",
         bandwidth = "and")

# Compare the results of all three models:
res = sapply(c("FM", "D", "IM"), cointReg, x = x, y = y, deter = deter)
do.call(cbind, lapply(res, "[[", "theta"))

}
\references{
\itemize{
    \item Phillips, P.C.B. and B. Hansen (1990): "Statistical Inference in
          Instrumental Variables Regression with I(1) Processes,"
          \emph{Review of Economic Studies}, 57, 99--125,
          \href{http://dx.doi.org/10.2307/2297545}{DOI:10.2307/2297545}.
    \item Phillips, P.C.B. and M. Loretan (1991): "Estimating Long Run
          Economic Equilibria," \emph{Review of Economic Studies}, 58,
          407--436,
          \href{http://dx.doi.org/10.2307/2298004}{DOI:10.2307/2298004}.
    \item Saikkonen, P. (1991): "Asymptotically Efficient Estimation of
          Cointegrating Regressions," \emph{Econometric Theory}, 7, 1--21,
          \href{http://dx.doi.org/10.1017/S0266466600004217}{DOI:10.1017/S0266466600004217}.
    \item Stock, J.H. and M.W. Watson (1993): "A Simple Estimator of
          Cointegrating Vectors in Higher Order Integrated Systems,"
          \emph{Econometrica}, 61, 783--820,
          \href{http://dx.doi.org/10.2307/2951763}{DOI:10.2307/2951763}.
    \item Vogelsang, T.J. and M. Wagner (2014): "Integrated Modified OLS
          Estimation and Fixed-b Inference for Cointegrating Regressions,"
          \emph{Journal of Econometrics}, 148, 741--760,
          \href{http://dx.doi.org/10.1016/j.jeconom.2013.10.015}{DOI:10.1016/j.jeconom.2013.10.015}.
  }
}
\seealso{
Other cointReg: \code{\link{cointRegD}},
  \code{\link{cointRegFM}}, \code{\link{cointRegIM}},
  \code{\link{plot.cointReg}}, \code{\link{print.cointReg}}
}

