% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longrun-var.R
\name{getLongRunWeights}
\alias{getLongRunWeights}
\title{Weights for Long-Run Variance}
\usage{
getLongRunWeights(n, bandwidth, kernel)
}
\arguments{
\item{n}{[\code{numeric(1)}]\cr
Length of weights' vector.}

\item{bandwidth}{[\code{numeric(1)}]\cr
The bandwidth (as number).}

\item{kernel}{[\code{character(1)}]\cr
The kernel function (see \code{\link{getLongRunVar}} for possible values).}
}
\value{
[\code{list}] with components:
\describe{
  \item{\code{w} [\code{numeric}]}{
    Vector of weights}

  \item{\code{upper} [\code{numeric(1)}]}{
    Index to largest non-zero entry in w}
}
}
\description{
Compute the weights corresponding to some kernel funtions.
}
\examples{
lrw.ba = cointReg:::getLongRunWeights(100, kernel = "ba", bandwidth = 25)
plot(lrw.ba$w)

}
\seealso{
\code{\link{getLongRunVar}}
}

