% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combiroc.R
\docType{package}
\name{combiroc}
\alias{combiroc}
\title{Taming Combinations of Biomarkers}
\description{
Easily and Powerfully Calculates Specificity, Sensitivity and ROC Curves of Biomarkers Combinations. In the following sections there is a brief summary of the package content.
}
\section{data loading and reshaping}{

\itemize{
\item load_data(): to check and load data.
\item load_unclassified_data(): to check and load unclassified data.
\item combiroc_long(): to reshape data in long format.
}
}

\section{distribution inspection}{

\itemize{
\item markers_distribution(): to show distribution of intensity values for all the markers both singularly and all together.
}
}

\section{combinatorial analysis}{

\itemize{
\item combi(): to compute marker combinations.
\item se_sp(): to compute sensitivity and specificity of each combination.
\item ranked_combs(): to rank combinations.
}
}

\section{logistic regression training and fitting}{

\itemize{
\item roc_reports(): to train logistic regression and compute ROC.
\item classify(): to apply the previously calculated models to an unclassified dataset and classifies the samples.
}
}

\section{markers/combinations correspondence}{

\itemize{
\item show_markers(): to show the composition of combinations
\item combs_with(): to show all combinations with given markers.
}
}

\section{built-in demo datasets}{

\itemize{
\item demo_data: proteomics data from Zingaretti et al. 2012 - PMC3518104)
\item demo_unclassified_data: dataset obtained by randomly picking 20 samples from demo_data without their classification.
}
}

