% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcDisc.r
\name{calcDisc}
\alias{calcDisc}
\alias{Disc}
\alias{disc}
\alias{calcdisc}
\title{Predicted Discomfort based on the 2-Node-Model}
\usage{
calcDisc(ta, tr, vel, rh, clo = 0.5, met = 1, wme = 0, pb = 760, ltime = 60, 
ht = 171, wt = 70, tu = 40, obj = "set", csw = 170, cdil = 120, cstr = 0.5)
}
\arguments{
\item{ta}{a numeric value presenting air temperature in [degree C]}

\item{tr}{a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{a numeric value presenting air velocity in [m/s]}

\item{rh}{a numeric value presenting relative humidity [\%]}

\item{clo}{a numeric value presenting clothing insulation level in [clo]}

\item{met}{a numeric value presenting metabolic rate in [met]}

\item{wme}{a numeric value presenting external work in [met]}

\item{pb}{a numeric value presenting barometric pressure in [torr] or [mmHg]}

\item{ltime}{a numeric value presenting exposure time in [minutes]}

\item{ht}{a numeric value presenting body height in [cm]}

\item{wt}{a numeric value presenting body weight in [kg]}

\item{tu}{a numeric value presenting turbulence intensity in [\%]}

\item{obj}{a character element, either "set" or "pmvadj"}

\item{csw}{a numeric value presenting the driving coefficient for regulatory sweating}

\item{cdil}{a numeric value presenting the driving coefficient for vasodilation}

\item{cstr}{a numeric value presenting the driving coefficient for vasoconstriction}
}
\value{
\code{calcDisc} returns the Predicted Discomfort
}
\description{
\code{calcDisc} calculates Predicted Discomfort based on the 2-Node-Model by 
Gagge et al.
}
\details{
All variables must have the same length 1. For the calculation of several 
values use function \code{calcComfInd}. The value of \code{obj} defines 
whether the function will use the version presented in ASHRAE 55-2013 for 
adjustment of pmv (obj = "pmvadj"), or the original code by Gagge to calculate 
set (obj = "set"). In the version presented in ASHRAE 55-2013, the lines of 
code related to self-generated convection is deleted. Therefore, a difference 
can only be seen at higher values of met.
}
\note{
In case one of the variables is not given, a standard value will be taken 
from a list (see \code{\link{createCond}} for details).
}
\examples{
## Using several rows of data:
ta <- c(20,22,24)
tr <- ta
vel <- rep(.15,3)
rh <- rep(50,3)

maxLength <- max(sapply(list(ta, tr, vel, rh), length))
Disc <- sapply(seq(maxLength), function(x) { calcDisc(ta[x], tr[x], vel[x], rh[x]) } ) 
}
\references{
ASHRAE Standard 55-2013. Thermal environmental conditions for human occupancy. 
American society of heating, Refrigerating and Air-Conditioning Engineering, 
Atlanta, USA, 2013.

Fountain & Huizenga (1995) A thermal sensation model for use by the 
engineering profession ASHRAE RP-781 Final report.

Gagge, Fobelets & Berglund (1986) A standard predictive index 
of human response to the thermal environment, ASHRAE transactions, 92 (2B), 709-731.
}
\seealso{
see also \code{\link{calcComfInd}}
}
\author{
The code for \code{calc2Node} is based on the code in BASIC and C++ presented 
by Fountain and Huizenga (1995). The translation into R-language and comparison 
with ASHRAE 55-2013 conducted by Marcel Schweiker.
}
