% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decileboxplot.R
\name{decileboxplot}
\alias{decileboxplot}
\title{Deciles BoxPlot from a PGS Association with a Continuous Phenotype}
\usage{
decileboxplot(df = NULL, prs_col = "SCORESUM", phenotype_col = "Phenotype")
}
\arguments{
\item{df}{a dataframe with individuals on each row, and at least the following
columns:
\itemize{
\item one ID column,
\item one PGS column, with numerical continuous values following a normal distribution,
\item one Phenotype column, can be numeric (Continuous Phenotype), character, boolean or factors (Discrete Phenotype)
}}

\item{prs_col}{a character specifying the PGS column name}

\item{phenotype_col}{a character specifying the Continuous Phenotype column name}
}
\value{
return a ggplot object (ggplot2)
}
\description{
\code{decileboxplot()} take a distribution of PGS, a Continuous Phenotype
return a plot with deciles of PGS in x and Boxplot of the Phenotype in y
}
