% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityplot.R
\name{densityplot}
\alias{densityplot}
\title{Density Plot from a PGS Association}
\usage{
densityplot(
  df = NULL,
  prs_col = "SCORESUM",
  phenotype_col = "Phenotype",
  scale = TRUE,
  threshold = NA
)
}
\arguments{
\item{df}{a dataframe with individuals on each row, and at least the following
columns:
\itemize{
\item one ID column,
\item one PGS column, with numerical continuous values following a normal distribution,
\item one Phenotype column, can be numeric (Continuous Phenotype), character, boolean or factors (Discrete Phenotype)
}}

\item{prs_col}{a character specifying the PGS column name}

\item{phenotype_col}{a character specifying the Phenotype column name}

\item{scale}{a boolean specifying if scaling of PGS should be done before plotting}

\item{threshold}{a facultative numeric specifying for Continuous Phenotype
the Threshold to consider individuals as Cases/Controls as following:
\itemize{
\item Phenotype > Threshold = Case
\item Phenotype < Threshold = Control
}}
}
\value{
return a ggplot object (ggplot2)
}
\description{
\code{densityplot()} take a distribution of PGS, a Phenotype and eventual Confounders
return a plot with density of PGS in x by Categories of the Phenotype
}
