\name{markQuestions}
\alias{markQuestions}
\title{ Apply a Marking Scheme }
\description{
  This function applies a marking scheme to a set of comparisons
  to produce a set of marks.
}
\usage{
markQuestions(result, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{result}{ A set of comparison results, as generated by the
    \code{compareFiles()} function. }
  \item{\dots}{ One or more marking schemes, as generated by the
    \code{questionMarks()} function. }
}
\value{
  A matrix of marks.
}
\author{ Paul Murrell }
\seealso{
  \code{\link{questionMarks}} and 
  \code{\link{compareFiles}}
}
\examples{
modelNames <- c("id", "age", 
                "edu", "class", 
                "IndianMothers")
files <- list.files(system.file("example", package="compare"),
                    pattern="^student[0-9]+[.]R$",
                    full.names=TRUE)

results <- compareFiles(files,
                        modelNames,
                        system.file("example", "model.R", package="compare"),
                        allowAll=TRUE,
                        resultNames=gsub(".+[/]|[.]R", "", files))
q1 <- questionMarks(c("id", "age", "edu", "class"),
                    maxMark=2,
                    rule("id", 1),
                    rule("age", 1),
                    rule("edu", 1),
                    rule("class", 1,
                         transformRule("coerced", 1)))

q2 <- questionMarks("IndianMothers",
                    maxMark=1,
                    rule("IndianMothers", 1))

markQuestions(results, q1, q2)
}
\keyword{utilities}
\keyword{logic}
