% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hype_par_unordered.R
\name{R6_par_unordered}
\alias{R6_par_unordered}
\title{R6 class for hyperparameter of discrete (factor) variable}
\description{
R6 class for hyperparameter of discrete (factor) variable

R6 class for hyperparameter of discrete (factor) variable
}
\examples{
p1 <- par_unordered('x1', c('a', 'b', 'c'))
class(p1)
print(p1)
}
\section{Super class}{
\code{comparer::par_hype} -> \code{par_unordered}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Name of the parameter, must match the input to `eval_func`.}

\item{\code{values}}{Vector of values}

\item{\code{ggtrans}}{Transformation for ggplot, see ggplot2::scale_x_continuous()}

\item{\code{lower}}{Lower bound of the parameter}

\item{\code{upper}}{Upper bound of the parameter}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-par_unordered-fromraw}{\code{R6_par_unordered$fromraw()}}
\item \href{#method-par_unordered-toraw}{\code{R6_par_unordered$toraw()}}
\item \href{#method-par_unordered-fromint}{\code{R6_par_unordered$fromint()}}
\item \href{#method-par_unordered-toint}{\code{R6_par_unordered$toint()}}
\item \href{#method-par_unordered-generate}{\code{R6_par_unordered$generate()}}
\item \href{#method-par_unordered-getseq}{\code{R6_par_unordered$getseq()}}
\item \href{#method-par_unordered-isvalid}{\code{R6_par_unordered$isvalid()}}
\item \href{#method-par_unordered-convert_to_mopar}{\code{R6_par_unordered$convert_to_mopar()}}
\item \href{#method-par_unordered-new}{\code{R6_par_unordered$new()}}
\item \href{#method-par_unordered-print}{\code{R6_par_unordered$print()}}
\item \href{#method-par_unordered-clone}{\code{R6_par_unordered$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_unordered-fromraw"></a>}}
\if{latex}{\out{\hypertarget{method-par_unordered-fromraw}{}}}
\subsection{Method \code{fromraw()}}{
Function to convert from raw scale to transformed scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_unordered$fromraw(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Value of raw scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_unordered-toraw"></a>}}
\if{latex}{\out{\hypertarget{method-par_unordered-toraw}{}}}
\subsection{Method \code{toraw()}}{
Function to convert from transformed scale to raw scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_unordered$toraw(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Value of transformed scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_unordered-fromint"></a>}}
\if{latex}{\out{\hypertarget{method-par_unordered-fromint}{}}}
\subsection{Method \code{fromint()}}{
Convert from integer index to actual value
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_unordered$fromint(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Integer index}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_unordered-toint"></a>}}
\if{latex}{\out{\hypertarget{method-par_unordered-toint}{}}}
\subsection{Method \code{toint()}}{
Convert from value to integer index
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_unordered$toint(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_unordered-generate"></a>}}
\if{latex}{\out{\hypertarget{method-par_unordered-generate}{}}}
\subsection{Method \code{generate()}}{
Generate values in the raw space based on quantiles.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_unordered$generate(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{In [0,1].}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_unordered-getseq"></a>}}
\if{latex}{\out{\hypertarget{method-par_unordered-getseq}{}}}
\subsection{Method \code{getseq()}}{
Get a sequence, uniform on the transformed scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_unordered$getseq(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of points. Ignored for discrete.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_unordered-isvalid"></a>}}
\if{latex}{\out{\hypertarget{method-par_unordered-isvalid}{}}}
\subsection{Method \code{isvalid()}}{
Check if input is valid for parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_unordered$isvalid(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Parameter value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_unordered-convert_to_mopar"></a>}}
\if{latex}{\out{\hypertarget{method-par_unordered-convert_to_mopar}{}}}
\subsection{Method \code{convert_to_mopar()}}{
Convert this to a parameter for the
mixopt R package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_unordered$convert_to_mopar(raw_scale = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw_scale}}{Should it be on the raw scale?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_unordered-new"></a>}}
\if{latex}{\out{\hypertarget{method-par_unordered-new}{}}}
\subsection{Method \code{new()}}{
Create a hyperparameter with uniform distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_unordered$new(name, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the parameter, must match the input to `eval_func`.}

\item{\code{values}}{The values the variable can take on.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_unordered-print"></a>}}
\if{latex}{\out{\hypertarget{method-par_unordered-print}{}}}
\subsection{Method \code{print()}}{
Print details of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_unordered$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{not used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_unordered-clone"></a>}}
\if{latex}{\out{\hypertarget{method-par_unordered-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_unordered$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
