% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/two.level.components.R
\name{two.level.components}
\alias{two.level.components}
\title{Compute integrated means and covariances}
\usage{
two.level.components(data, data.columns, item.column)
}
\arguments{
\item{data}{a \code{matrix}, or \code{data.frame}, of observations, with cases in rows,
and properties as columns}

\item{data.columns}{a \code{vector} indicating which columns are the properties}

\item{item.column}{an integer indicating which column gives the item}
}
\value{
an object of class \code{compvar}
}
\description{
Takes a large sample from the background population and calculates the within
and between covariance matrices, a vector of means, a vector of the counts of
replicates for each item from the sample, and other bits needed to make up a
\code{compcovar} object.
}
\details{
Uses ML estimation at the moment - this will almost certainly change in the future and
hopefully allow regularisation methods to get a more stable (and non-singular) estimate.
}
\examples{
# load Greg Zadora's glass data
data(glass)

# calculate a compcovar object based upon glas
# using K, Ca and Fe - warning - could take time
# on slower machines
Z = two.level.components(glass, c(7,8,9), 1)
}
