% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LoggerTime}
\alias{LoggerTime}
\title{Logger class to log the elapsed time}
\format{\code{\link{S4}} object.}
\description{
This class just logs the elapsed time. This should be very handy if one
wants to run the algorithm for just 2 hours and see how far he comes within
that time. There are three time units available for logging:
\itemize{
  \item minutes
  \item seconds
  \item microseconds
}
}
\section{Usage}{

\preformatted{
LoggerTime$new(use_as_stopper, max_time, time_unit)
}
}

\section{Arguments}{

\describe{
\item{\code{use_as_stopper} [\code{logical(1)}]}{
  Boolean to indicate if the logger should also be used as stopper.
}
\item{\code{max_time} [\code{integer(1)}]}{
  If the logger is used as stopper this argument contains the maximal time
  which are available to train the model.
}
\item{\code{time_unit} [\code{character(1)}]}{
  Character to specify the time unit. Possible choices are \code{minutes},
  \code{seconds} or \code{microseconds}
}
}
}

\section{Details}{


  This class is a wrapper around the pure \code{C++} implementation. To see
  the functionality of the \code{C++} class visit
  \url{https://schalkdaniel.github.io/compboost/cpp_man/html/classlogger_1_1_time_logger.html}.
}

\section{Fields}{

  This class doesn't contain public fields.
}

\section{Methods}{

\describe{
\item{\code{summarizeLogger()}}{Summarize the logger object.}
}
}

\examples{
# Define logger:
log.time = LoggerTime$new(FALSE, 20, "minutes")

# Summarize logger:
log.time$summarizeLogger()

}
