% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LossCustom}
\alias{LossCustom}
\title{Create LossCustom by using R functions.}
\format{\code{\link{S4}} object.}
\description{
\code{LossCustom} creates a custom loss by using
\code{Rcpp::Function} to set \code{R} functions.
}
\section{Usage}{

\preformatted{
LossCustom$new(lossFun, gradientFun, initFun)
}
}

\section{Arguments}{

\describe{
\item{\code{lossFun} [\code{function}]}{
  \code{R} function to calculate the loss. For details see the
  \code{Details}.
}
\item{\code{gradientFun} [\code{function}]}{
  \code{R} function to calculate the gradient. For details see the
  \code{Details}.
}
\item{\code{initFun} [\code{function}]}{
  \code{R} function to calculate the constant initialization. For
  details see the \code{Details}.
}
}
}

\section{Details}{

  The functions must have the following structure:

  \code{lossFun(truth, prediction) { ... return (loss) }} With a vector
  argument \code{truth} containing the real values and a vector of
  predictions \code{prediction}. The function must return a vector
  containing the loss for each component.

  \code{gradientFun(truth, prediction) { ... return (grad) }} With a vector
  argument \code{truth} containing the real values and a vector of
  predictions \code{prediction}. The function must return a vector
  containing the gradient of the loss for each component.

  \code{initFun(truth) { ... return (init) }} With a vector
  argument \code{truth} containing the real values. The function must
  return a numeric value containing the offset for the constant
  initialization.

  For an example see the \code{Examples}.

  This class is a wrapper around the pure \code{C++} implementation. To see
  the functionality of the \code{C++} class visit
  \url{https://schalkdaniel.github.io/compboost/cpp_man/html/classloss_1_1_custom_loss.html}.
}

\examples{

# Loss function:
myLoss = function (true.values, prediction) {
  return (0.5 * (true.values - prediction)^2)
}
# Gradient of loss function:
myGradient = function (true.values, prediction) {
  return (prediction - true.values)
}
# Constant initialization:
myConstInit = function (true.values) {
  return (mean(true.values))
}

# Create new custom quadratic loss:
my.loss = LossCustom$new(myLoss, myGradient, myConstInit)

}
