% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvar.R
\name{cvar}
\alias{cvar}
\alias{ccov}
\alias{ccor}
\alias{ccov2cor}
\alias{covar}
\title{Correlation, Variance and Covariance (Matrices) for complex variables}
\usage{
cvar(x, method = c("direct", "conjugate"), df = NULL, ...)

ccov(x, y, method = c("direct", "conjugate"), df = NULL, ...)

ccor(x, y, method = c("direct", "conjugate", "pearson", "kendall",
  "spearman"), ...)

ccov2cor(V)

covar(x, df = NULL)
}
\arguments{
\item{x}{vector or matrix of complex variables. If it is matrix then the
variable \code{y} is ignored.}

\item{method}{method to use in the calculation of the measure. \code{"conjugate"} means that it is based
on the multiplication by conjugate number. \code{"direct"} means the calculation
without the conjugate (i.e. "pseudo" moment). For \code{ccor} the variable \code{method}
can also be "pearson", "kendall", or "spearman", defining what correlation coefficient
to use after the MDS transformation of complex variables \code{x} and \code{y}.}

\item{df}{Number of degrees of freedom to use in the calculation of the statistics.}

\item{...}{parameters passed to \code{mean()} functions. For example, this can be
\code{na.rm=TRUE} to remove missing values or \code{trim} to define the trimming
in the mean (see \link[base]{mean}).}

\item{y}{second vector to calculate covariance or correlations with.}

\item{V}{complex (pseudo)covariance matrix.}
}
\value{
A scalar or a matrix with resulting complex variables.
}
\description{
Functions \code{cvar()}, \code{ccov()} and \code{ccor()} return respectively
complex variance, covariance and correlation based on the
provided complex vector/matrix \code{x}. Function \code{covar()} returns the covariance
matrix based on a complex vector/matrix.
}
\details{
Only the parametric correlation is supported by the function. If \code{x}
is matrix, then \code{y} is ignored.

\code{covar()} function returns a covariance matrix calculated for the provided complex
vector or matrix \code{x}.
}
\examples{

# Generate random complex variables
x <- complex(real=rnorm(100,10,10), imaginary=rnorm(100,10,10))
y <- complex(real=rnorm(100,10,10), imaginary=rnorm(100,10,10))

# Create a matrix of complex variables
z <- cbind(x,y)

# Calculate measures
cvar(x)
cvar(z)
ccor(x,y)
ccor(z)

}
\references{
\itemize{
\item Svetunkov, S. & Svetunkov I. (2022) Complex Autoregressions. In Press.
}
}
\seealso{
\code{\link[stats]{cor}}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{univar}
