% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{complexdqlrs}
\alias{complexdqlrs}
\title{An alternative to \verb{.Call(C_Cdqlrs, x * wts, y * wts, tol, FALSE))} that is compatible with complex variables}
\usage{
complexdqlrs(x, y, tol = 1e-07, chk)
}
\arguments{
\item{x}{a complex matrix (will also accept numeric, but in that case you might as well use \code{C_Cdqlrs}) whose QR decomposition is to be computed.}

\item{y}{a complex vector or matrix of right-hand side quantities.}

\item{tol}{the tolerance for detecting linear dependencies in the columns of x. Not used for complex \code{x}.}

\item{chk}{not used. Included to better imitate \code{C_Cdqlrs}.}
}
\value{
A list that includes the qr decomposition, its coeffcionts, residuals, effects, rank, pivot information, qraux vector,
tolerance, and whether or not it was pivoted. This is the same output as \code{C_Cdqlrs}.
}
\description{
This serves as a wrapper for qr, replicating the behavior and output of the C++ function \code{C_Cdqlrs}. It is used in \code{zlm.wfit},
and is unlikely to be needed by end users.
}
\examples{
set.seed(4242)
n <- 8
slope <- complex(real = 4.23, imaginary = 2.323)
intercept <- complex(real = 1.4, imaginary = 1.804)
x <- complex(real = rnorm(n), imaginary = rnorm(n))
y <- slope * x + intercept
complexdqlrs(x, y, 10^-4, 1.2)
}
\seealso{
\link[base:qr]{base::qr}, \link{lm}, \link{zlm.wfit}, \link{rlm}
}
