% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isomLR.R
\name{isomLR}
\alias{isomLR}
\alias{isomLRinv}
\title{(Inverse) Isometric log-ratio transformation for compositional data}
\usage{
isomLR(x, comp = 1)

isomLRinv(z, perc = TRUE)
}
\arguments{
\item{x}{a numeric vector of length \code{D} or a numeric matrix with \code{D} columns}

\item{comp}{the component to use as the first compositional part}

\item{z}{a numeric vector of length \code{D-1} or a numeric matrix with \code{D-1} columns.}

\item{perc}{should the result be a matrix with percentage shares (default \code{TRUE}).}
}
\value{
\code{isomLR}: a numeric matrix with \code{(D-1)} columns with the transformed values. The name of the first
    	column is the name of the first part (the other names are according to the order of the
		columns in the given matrix \code{x})

\code{isomLRinv}: a numeric matrix with \code{D} columns with the transformed values. The
values in the matrix are not on the original scale, but the percentage shares are equal.
}
\description{
Projects the D-dimensional compositional data on the (D-1)-dimensional simplex isometrically back
and forth by transforming the values according to
\deqn{z_i = \sqrt{\frac{D - i}{D -i + 1}}  \log{ \frac{x_i}{ \left( \prod_{j=i+1}^{D} x_j \right)^{1/(D - i)} }}}{
 z_i = \sqrt((D - i)/(D - i + 1)) log( x_i / (\prod (j = i + 1 ... D) x_j)^(1/(D - i)) }
}
\section{Functions}{
\itemize{
\item \code{isomLRinv}: Inverse transformation
}}

\examples{
X <- as.matrix(USArrests[ , -3])
# Get the ilr with relative information of the 1st column to the other cols
ilrZ1 <- isomLR(X)
# Get the ilr with relative information of the 2nd column to the other cols
ilrZ2 <- isomLR(X, 2)
isomLRinv(ilrZ1)
}
