% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct_countries_table.R
\name{ct_countries_table}
\alias{ct_countries_table}
\title{Extract country code look up table from UN Comtrade}
\usage{
ct_countries_table(reporters = NULL, partners = NULL)
}
\arguments{
\item{reporters}{Default value NULL, otherwise this should be a url as a
char string that points to the reporter areas JSON dataset on the Comtrade
website. Only necessary if the Comtrade site changes from
\url{https://comtrade.un.org/data/cache/reporterAreas.json}}

\item{partners}{Default value NULL, otherwise this should be a url as a
char string that points to the reporter areas JSON dataset on the Comtrade
website. Only necessary if the Comtrade site changes from
\url{https://comtrade.un.org/data/cache/partnerAreas.json}}
}
\value{
A dataframe of countries and country codes, downloaded from UN
 Comtrade.
}
\description{
Returns a dataframe of countries and country codes,
downloaded from UN Comtrade. For use with the UN Comtrade API, full API
docs can be found at \url{https://comtrade.un.org/data/doc/api/}
}
\examples{
\dontrun{
countrydf <- ct_countries_table()
}
}
