% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct_get_bulk.R
\name{ct_get_bulk}
\alias{ct_get_bulk}
\title{Get trade data from the UN Comtrade API}
\usage{
ct_get_bulk(
  type = "goods",
  frequency = "A",
  commodity_classification = "HS",
  reporter = "all_countries",
  start_date = NULL,
  end_date = NULL,
  tidy_cols = TRUE,
  verbose = FALSE,
  primary_token = get_primary_comtrade_key(),
  update = FALSE,
  requests_per_second = 10/60,
  cache = FALSE,
  download_bulk_files = TRUE
)
}
\arguments{
\item{type}{The type of returned trade data.
Possible values: 'goods' for trade in goods,
'services' for trade in services. Default: 'goods'.}

\item{frequency}{The frequency of returned trade data.
Possible values: 'A' for annual data, 'M' for monthly data. Default: 'A'.}

\item{commodity_classification}{The trade classification scheme.
Possible values for goods:
\code{c('HS','H0','H1','H2','H3','H4','H5','H6')}and
\verb{c(S1','S2','S3','S4','SS','B4','B5')};
for services: \code{c('EB02','EB10','EB10S','EB')}. Default: 'HS'.}

\item{reporter}{Reporter ISO3 code(s), \code{everything} or \code{all_countries}.
See \code{comtradr::country_codes} or \code{comtradr::ct_get_ref_table('reporter')}
for possible values. \code{all_countries} returns all countries without aggregates
\code{everything} returns all possible parameters. Default: 'all_countries'.}

\item{start_date}{The start date of the query.
Format: \code{yyyy} for yearly, \code{yyyy-mm} for monthly.}

\item{end_date}{The end date of the query.
Format: \code{yyyy} for yearly, \code{yyyy-mm} for monthly.
Max: 12 years after start date for annual data, one year for monthly data.}

\item{tidy_cols}{If TRUE, returns tidy column names.
If FALSE, returns raw column names. Default: TRUE.}

\item{verbose}{If TRUE, sends status updates to the console.
If FALSE, runs functions quietly. Default: FALSE.}

\item{primary_token}{Your primary UN Comtrade API token.
Default: stored token from \code{comtradr::set_primary_comtrade_key}.}

\item{update}{If TRUE, downloads possibly updated reference tables
from the UN. Default: FALSE.}

\item{requests_per_second}{Rate of requests per second executed,
usually specified as a fraction, e.g. 10/60 for 10 requests per minute,
see \code{req_throttle()} for details.}

\item{cache}{A logical value to determine, whether requests should be cached
or not. If set to True, \code{rappdirs::user_cache_dir()} is used
to determine the location of the cache. Use the .Renviron file to set the
R_USER_CACHE_DIR in order to change this location. Default: False.}

\item{download_bulk_files}{If TRUE downloads all files that are returned
from the Comtrade API as a list for the specified parameters. This can
result in large writing and reading operations from your file system.}
}
\value{
A data.frame with trade data or,
if \code{process = FALSE}, a httr2 response object.
}
\description{
This function queries the UN Comtrade API to retrieve
international trade data.
It allows for detailed specification of the query,
including the type of data (goods or services),
frequency (annual or monthly), commodity classification,
flow direction, and more.
By providing \code{everything} for certain parameters,
you can query all possible values.
The function is opinionated in that it already verifies certain parameters
for you and is more than a pure wrapper around the API.
}
\details{
The UN Comtrade database provides a repository of official international
trade statistics and relevant analytical tables.
It contains annual trade statistics starting from 1988
and monthly trade statistics since 2000 for goods data

Parameters that accept \code{everything} will query all possible values.
For example, setting \code{commodity_code = 'everything'}
will retrieve data for all commodity codes.
This can be useful for broad queries but may result in large datasets.
}
