% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.R
\name{contrast}
\alias{contrast}
\alias{modtrast}
\alias{bootcri}
\title{Build contrast tree}
\usage{
contrast(
  x,
  y,
  z,
  w = rep(1, nrow(x)),
  cat.vars = NULL,
  not.used = NULL,
  qint = 10,
  xmiss = 9e+35,
  tree.size = 10,
  min.node = 500,
  mode = c("onesamp", "twosamp"),
  type = "dist",
  pwr = 2,
  quant = 0.5,
  nclass = NULL,
  costs = NULL,
  cdfsamp = 500,
  verbose = FALSE,
  tree.store = 1e+06,
  cat.store = 1e+05,
  nbump = 1,
  fnodes = 0.25,
  fsamp = 1,
  doprint = FALSE
)

modtrast(
  x,
  y,
  z,
  w = rep(1, nrow(x)),
  cat.vars = NULL,
  not.used = NULL,
  qint = 10,
  xmiss = 9e+35,
  tree.size = 10,
  min.node = 500,
  learn.rate = 0.1,
  type = c("dist", "diff", "class", "quant", "prob", "maxmean", "diffmean"),
  pwr = 2,
  quant = 0.5,
  cdfsamp = 500,
  verbose = FALSE,
  tree.store = 1e+06,
  cat.store = 1e+05,
  nbump = 1,
  fnodes = 0.25,
  fsamp = 1,
  doprint = FALSE,
  niter = 100,
  doplot = FALSE,
  span = 0,
  plot.span = 0.15,
  print.itr = 10
)

bootcri(
  x,
  y,
  z,
  w = rep(1, nrow(x)),
  cat.vars = NULL,
  not.used = NULL,
  qint = 10,
  xmiss = 9e+35,
  tree.size = 10,
  min.node = 500,
  mode = "onesamp",
  type = "dist",
  pwr = 2,
  quant = 0.5,
  nclass = NULL,
  costs = NULL,
  cdfsamp = 500,
  verbose = FALSE,
  tree.store = 1e+06,
  cat.store = 1e+05,
  nbump = 100,
  fnodes = 1,
  fsamp = 1,
  doprint = FALSE
)
}
\arguments{
\item{x}{training input predictor data matrix or data frame. Rows
are observations and columns are variables. Must be a numeric
matrix or a data frame.}

\item{y}{vector, or matrix containing training data input outcome
values or censoring intervals for each observation. if y is a
vector then it implies that y uncensored outcome values or
other contrasting quantity. If y is a matrix, then then y is
assumed to be censoring intervals for each observation; see
details below}

\item{z}{vector containing values of a second contrasting quantity
for each observation}

\item{w}{training observation weights}

\item{cat.vars}{vector of column labels (numbers or names)
indicating categorical variables (factors). All variables not
so indicated are assumed to be orderable numeric; see details
below}

\item{not.used}{vector of column labels (numbers or names)
indicating predictor variables not to be used in the model}

\item{qint}{maximum number of split evaluation points on each
predictor variable}

\item{xmiss}{missing value flag. Must be numeric and larger than
any non missing predictor/abs(response) variable value.
Predictor variable values greater than or equal to xmiss are
regarded as missing. Predictor variable data values of \code{NA} are
internally set to the value of xmiss and thereby regarded as
missing}

\item{tree.size}{maximum number of terminal nodes in generated
trees}

\item{min.node}{minimum number of training observations in each
tree terminal node}

\item{mode}{indicating one or two-sample contrast; see details
below for how it works with type}

\item{type}{type of contrast; see details below for how it works
with mode}

\item{pwr}{center split bias parameter. Larger values produce less
center split bias.}

\item{quant}{specified quantile p (type='quant' only)}

\item{nclass}{number of classes (type ='class' only) default=2}

\item{costs}{nclass by nclass misclassification cost matrix
(type='class' only); default is equal valued diagonal (error
rate)}

\item{cdfsamp}{= maximum subsample size used to compute censored
CDF (censoring only)}

\item{verbose}{a logical flag indicating print/don't print censored
CDF computation progress, default \code{FALSE}}

\item{tree.store}{size of internal tree storage. Decrease value in
response to memory allocation error. Increase value for very
large values of max.trees and/or tree.size, or in response to
diagnostic message or erratic program behavior}

\item{cat.store}{size of internal categorical value
storage. Decrease value in response to memory allocation
error. Increase value for very large values of max.trees and/or
tree.size in the presence of many categorical variables
(factors) with many levels, or in response to diagnostic
message or erratic program behavior}

\item{nbump}{number of bootstrap replications}

\item{fnodes}{top fraction of node criteria used to evaluate trial
bumped trees}

\item{fsamp}{fraction of observations used in each bootstrap sample
for bumped trees}

\item{doprint}{logical flag \code{TRUE/FALSE} implies do/don't plot iteration progress}

\item{learn.rate}{learning rate parameter in \verb{(0,1]}}

\item{niter}{number of trees}

\item{doplot}{a flag to display/not display graphical plots}

\item{span}{span for qq-plot transformation smoother}

\item{plot.span}{running median smoother span for discrepancy plot (\code{doplot = TRUE}, only)}

\item{print.itr}{tree discrepancy printing iteration interval}
}
\value{
a contrast model object use as input to interpretation
procedures

a contrast model object to be used with predtrast()

a named list with \code{out$bcri} the bootstraped discrepancy values
}
\description{
Build contrast tree

Build boosted contrast tree model

Bootstrap contrast trees
}
\details{
The varible \code{xmiss} is the missing value flag, Must be
numeric and larger than any non missing predictor/abs(response) variable value.  Predictor variable values greater than or equal to \code{xmiss} are regarded as missing. Predictor variable data values of \code{NA} are internally set to the value of xmiss and thereby regarded as missing.

If the response y is a matrix, it is assumed to contain censoring
intervals for each observation. Rows are observations.
\itemize{
\item First/second column are lower/upper boundary of censoring interval (Can be same value for uncensored observations) respectively
\item \code{y[,1] = -xmiss} implies outcome less than or equal to \code{y[,2]} (censored from above)
\item \code{y[,2] = xmiss} implies outcome greater than or equal to \code{y[,1]}
}

Note that censoring is only allowed for \code{type='dist'}; see further below.

If x is a data frame and \code{cat.vars} (the columns indicating
categorical variables), is missing, then components of type factor
are treated as categorical variables. Ordered factors should be
input as type numeric with appropriate numerical scores. If
\code{cat.vars} is present it will over ride the data frame typing.

The \code{mode} argument is either
\itemize{
\item \code{'onesamp'} (default) meaning one \code{x}-vector for each \verb{(x,z)} pair
\item \code{'twosamp'} implies two-sample contrast with
\itemize{
\item \code{x} are predictor variables for both samples
\item \code{y} are outcomes for both samples
\item \code{z} is sample identity flag with \code{z < 0} implying first sample observations and \code{z > 0}, the second sample observations.
The \code{type} argument indicates the type of contrast. It can be either a user defined function or a string. If \code{mode} is \code{'onesamp'}, the default,
}
\item \code{type = 'dist'} (default) implies contrast distribution of \code{y} with that of \code{z} (\code{y} may be censored - see above)
\item \code{type = 'diff'} implies contrast joint paired values of \code{y} and \code{z}
\item \code{type = 'class'} implies classification: contrast class labels \code{y[i]} and \code{z[i]} are two class labels (in \code{1:nclass}) for each observation.
\item \code{type = 'prob'} implies contrast predicted with empirical probabilities: \code{y[i] = 0/1} and  \code{z[i]} is predicted probability \eqn{P(y=1)} for \eqn{i}-th observation
\item \code{type = 'quant'} is contrast predicted with empirical quantiles: \code{y[i]} is outcome value for \eqn{i}-th observation and \code{z[i]} is predicted \eqn{p}-th quantile value (see below) for \eqn{i}-th observation \eqn{(0 < p <1)}
\item \code{type = 'diffmean'} implies maximize absolute mean difference between \code{y} and \code{z}
\item \code{type = 'maxmean'} implies maximize signed mean difference between \code{y} and \code{z}
}

When mode is \code{'twosamp'}
\itemize{
\item \code{type= 'dist'} (default) implies contrast \code{y} distributions of both samples
\item \code{type = 'diffmean'} implies maximize absolute difference between means of two samples
\item \code{type = 'maxmean'} maximize signed difference between means of two samples
}

When \code{type} is a function, it must be a function of three arguments
\code{f(y,z,w)} where \code{y} and \code{z} are double vectors and \code{w} is a weight
vector, not necessarily normalized. The function should return a
double vector of length 1 as the result. See example below.
}
\examples{
data(census, package = "conTree")
dx <- 1:10000; dxt <- 10001:16281;
# Build contrast tree
tree <- contrast(census$xt[dx,], census$yt[dx], census$gblt[dx], type = 'prob')
# Summarize tree
treesum(tree)
# Get terminal node identifiers for regions containing observations 1 through 10
getnodes(tree, x = census$xt[1:10, ])
# Plot nodes
nodeplots(tree, x = census$xt[dx, ], y = census$yt[dx], z = census$gblt[dx])
# Summarize contrast tree against (precomputed) gradient boosting
# on logistic scale using maximum likelihood (GBL)
nodesum(tree, census$xt[dxt,], census$yt[dxt], census$gblt[dxt])
# Use a custom R discrepancy function to build a contrast tree
dfun <- function(y, z, w) {
   w  <- w / sum(w)
   abs(sum(w * (y - z)))
}
tree2 <- contrast(census$xt[dx,], census$yt[dx], census$gblt[dx], type = dfun)
nodesum(tree2, census$xt[dxt,], census$yt[dxt], census$gblt[dxt])
# Generate lack of fit curve
lofcurve(tree, census$xt[dx,], census$yt[dx], census$gblt[dx])
# Build contrast tree boosting models
# Use small # of iterations for illustration (typically >= 200)
modgbl = modtrast(census$x, census$y, census$gbl, type = 'prob', niter = 10)
# Plot model accuracy as a function of iteration number
xval(modgbl, census$x, census$y, census$gbl, col = 'red')
# Produce predictions from modtrast() for new data.
ypred <- predtrast(modgbl, census$xt, census$gblt, num = modgbl$niter)
# Produce distribution boosting estimates
yhat <- predtrast(modgbl, census$xt, census$gblt, num = modgbl$niter)
}
\references{
Jerome H. Friedman (2020). \url{doi:10.1073/pnas.1921562117}
}
\author{
Jerome H. Friedman
}
