% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rule_fill_bar.R
\name{rule_fill_bar}
\alias{rule_fill_bar}
\title{Fill column with a bar of a length proportional to a value}
\usage{
rule_fill_bar(x, columns, expression, low = "darkgreen",
  high = "white", background = "white", na.value = "gray",
  limits = NA, lockcells = FALSE)
}
\arguments{
\item{x}{A condformat object, typically created with \code{\link[=condformat]{condformat()}}}

\item{columns}{A character vector with column names to be coloured. Optionally
\code{\link[tidyselect:select_helpers]{tidyselect::select_helpers()}} can be used.}

\item{expression}{an expression to be evaluated with the data.
It should evaluate to a numeric vector,
that will be used to determine the colour gradient level.}

\item{low}{Colour for the beginning of the bar}

\item{high}{Colour for the end of the bar}

\item{background}{Background colour for the cell}

\item{na.value}{Colour for missing values}

\item{limits}{range of limits that the gradient should cover}

\item{lockcells}{logical value determining if no further rules should be applied to the affected cells.}
}
\value{
The condformat_tbl object, with the added formatting information
}
\description{
Fills the background of a column cell using a bar proportional to the value
of the cell
}
\examples{
data(iris)
condformat(iris[c(1:5, 70:75, 120:125), ]) \%>\% rule_fill_bar("Sepal.Length")
}
\seealso{
Other rule: \code{\link{rule_css}},
  \code{\link{rule_fill_discrete}},
  \code{\link{rule_fill_gradient2}},
  \code{\link{rule_fill_gradient}},
  \code{\link{rule_text_bold}},
  \code{\link{rule_text_color}}
}
\concept{rule}
