% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condtour.R
\name{condtour}
\alias{condtour}
\title{Conditional tour; a tour through sections in data space}
\usage{
condtour(data, model, path, response = NULL, sectionvars = NULL,
  conditionvars = NULL, threshold = NULL, lambda = NULL,
  distance = c("euclidean", "maxnorm"), view3d = FALSE, conf = FALSE,
  col = "black", pch = 1, xcplotpar = NULL)
}
\arguments{
\item{data}{A dataframe.}

\item{model}{A fitted model object, or a list of such objects.}

\item{path}{A dataframe, describing the sections to take. Basically a
dataframe with its \code{colnames} being a subset of the
\code{colnames(data)}.}

\item{response}{Character name of response variable in \code{data}.}

\item{sectionvars}{Character name(s) of variables in \code{data} on which to
take sections.}

\item{conditionvars}{Character name(s) of variables in \code{data} on which
to condition.}

\item{threshold}{Threshold distance. Observed data which are a distance
greater than \code{threshold} from the current section are not visible.
Passed to \code{\link{similarityweight}}.}

\item{lambda}{A constant to multiply by number of factor mismatches in
constructing a general dissimilarity measure. If left \code{NULL}, behaves
as though \code{lambda} is set greater than \code{threshold}, and so only
observations whose factor levels match the current section are visible.
Passed to \code{\link{similarityweight}}.}

\item{distance}{The type of distance measure to use, either
\code{"euclidean"} (default) or \code{"maxnorm"}.}

\item{view3d}{Logical; if \code{TRUE}, plots a three-dimensional regression
surface when possible.}

\item{conf}{Logical; if \code{TRUE}, plots confidence bounds or equivalent
when possible.}

\item{col}{Colour for observed data points.}

\item{pch}{Plot symbols for observed data points.}

\item{xcplotpar}{Plotting parameters for condition selector plots as a list,
passed to \code{\link{plotxc}}. Can specify \code{cex.axis}, \code{cex.lab}
, \code{tck}, \code{col} for highlighting current section, \code{cex}.}
}
\value{
Produces a set of interactive plots. One device displays the current
  section. A second device shows the the current section in the space of the
  conditioning predictors given by \code{conditionvars}. A third device shows
  some simple diagnostic plots; one to show approximately how much data are
  visible on each section, and another to show what proportion of data are
  \emph{visited} by the tour.
}
\description{
Whereas \code{\link{ceplot}} allows the user to interactively
  choose sections to visualise, \code{condtour} allows the user to pre-select
  all sections to visualise, order them, and cycle through them one by one.
  ']' advances the tour, and '[' goes back.
}
\examples{
\dontrun{

data(powerplant)
library(e1071)
model <- svm(PE ~ ., data = powerplant)
path <- makepath(powerplant[-5], 25)
condtour(data = powerplant, model = model, path = path$path,
  sectionvars = "AT")

data(wine)
wine$Class <- as.factor(wine$Class)
library(e1071)
model5 <- list(svm(Class ~ ., data = wine))
conditionvars1 <- setdiff(colnames(wine), c("Class", "Hue", "Flavanoids"))
path <- makepath(wine[, conditionvars1], 50)
condtour(data = wine, model = model5, path = path$path, sectionvars = c("Hue"
  , "Flavanoids"), threshold = 3)

}
}
\seealso{
\code{\link{ceplot}}, \code{\link{similarityweight}}
}

