% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coversim.R
\name{coversim}
\alias{coversim}
\title{Confidence Region Coverage}
\usage{
coversim(alpha, distn,
                n         = NULL,
                iter      = NULL,
                dataset   = NULL,
                point     = NULL,
                seed      = NULL,
                kappa     = NULL,
                lambda    = NULL,
                mu        = NULL,
                sigma     = NULL,
                theta     = NULL,
                heuristic = 1,
                maxdeg    = 5,
                ellipse_n = 4,
                pts       = FALSE,
                mlelab    = TRUE,
                sf        = c(5, 5),
                mar       = c(4, 4.5, 2, 1.5),
                xlab      = "",
                ylab      = "",
                main      = paste0("alpha: ", a, "  n: ", samp),
                xlas      = 1,
                ylas      = 2,
                origin    = FALSE,
                xlim      = NULL,
                ylim      = NULL,
                tol       = .Machine$double.eps ^ 0.5,
                info      = FALSE,
                returnsamp   = FALSE,
                returnquant   = FALSE,
                repair    = TRUE,
                showplot  = FALSE,
                delay     = 0 )
}
\arguments{
\item{alpha}{significance level; resulting plot illustrates a 100(1 - alpha)\% confidence region.}

\item{distn}{distribution to fit the dataset to; accepted values: \code{'gamma'}, \code{'invgauss'},
\code{'lnorm'}, \code{'llogis'}, \code{'norm'}, \code{'weibull'}.}

\item{n}{trial sample size (producing each confidence region); needed if a dataset is not given.}

\item{iter}{iterations of individual trials per parameterization; needed if a dataset is not given.}

\item{dataset}{a \code{'n'} x \code{'iter'} matrix of dataset values.}

\item{point}{coverage is assessed relative to this point.}

\item{seed}{random number generator seed.}

\item{kappa}{distribution parameter (when applicable).}

\item{lambda}{distribution parameter (when applicable).}

\item{mu}{distribution parameter (when applicable).}

\item{sigma}{distribution parameter (when applicable).}

\item{theta}{distribution parameter (when applicable).}

\item{heuristic}{numeric value selecting method for plotting: 0 for elliptic-oriented point distribution, and
1 for smoothing boundary search heuristic.}

\item{maxdeg}{maximum angle tolerance between consecutive plot segments in degrees.}

\item{ellipse_n}{number of roughly equidistant confidence region points to plot using the
elliptic-oriented point distribution (must be a multiple of four because its algorithm
exploits symmetry in the quadrants of an ellipse).}

\item{pts}{displays confidence region boundary points if \code{TRUE}.}

\item{mlelab}{logical argument to include the maximum
likelihood estimate coordinate point (default is \code{TRUE}).}

\item{sf}{specifies the number of significant figures on axes labels.}

\item{mar}{specifies margin values for \code{par(mar = c( ))} (see \code{mar} in \code{\link{par}}).}

\item{xlab}{string specifying the x axis label.}

\item{ylab}{string specifying the y axis label.}

\item{main}{string specifying the plot title.}

\item{xlas}{numeric in {0, 1, 2, 3} specifying the style of axis labels (see \code{las} in \code{\link{par}}).}

\item{ylas}{numeric in {0, 1, 2, 3} specifying the style of axis labels (see \code{las} in \code{\link{par}}).}

\item{origin}{logical argument to include the plot origin (default is \code{FALSE}).}

\item{xlim}{two element vector containing horizontal axis minimum and maximum values.}

\item{ylim}{two element vector containing vertical axis minimum and maximum values.}

\item{tol}{the \code{\link{uniroot}} parameter specifying its required accuracy.}

\item{info}{logical argument to return coverage information in a list; includes alpha value(s), n value(s), coverage
and error results per iteration, and \code{returnsamp} and/or \code{returnquant} when requested.}

\item{returnsamp}{logical argument; if \code{TRUE} returns random samples used in a matrix with n rows, iter cols.}

\item{returnquant}{logical argument; if \code{TRUE} returns random quantiles used in a matrix with n rows, iter cols.}

\item{repair}{logical argument to repair regions inaccessible using a radial angle from its MLE (multiple root azimuths).}

\item{showplot}{logical argument specifying if each coverage trial produces a plot.}

\item{delay}{numeric value of delay (in seconds) between trials so its plot can be seen.}
}
\value{
if the optional argument \code{info = TRUE} is included then a list of coverage results is returned.
}
\description{
Creates a confidence region and determines coverage results for a corresponding point of interest.
Iterates through a user specified number of trials.
Each trial uses a random dataset with user-specified parameters (default) or a user specified dataset
matrix (\code{'n'} samples per column, \code{'iter'} columns) and returns the corresponding actual coverage results.
}
\details{
This package uses the following parameterization for its supported distributions, and illustrates
the corresponding confidence regions accordingly:

\itemize{
\item The gamma distribution
for shape parameter \eqn{\kappa > 0}, scale parameter \eqn{\theta > 0}, and \eqn{x > 0},
has the probability density function
\deqn{1 / (Gamma(\kappa) \theta ^ \kappa) x ^ {(\kappa - 1)} exp(-x / \theta).}

\item The inverse Gaussian distribution
for mean \eqn{\mu > 0}, shape parameter \eqn{\lambda > 0}, and \eqn{x > 0},
has the probability density function
\deqn{\sqrt (\lambda / (2 \pi x ^ 3)) exp( - \lambda (x - \mu) ^ 2 / (2 \mu ^ 2 x)).}

\item The log logistic distribution
for scale parameter \eqn{\lambda > 0}, shape parameter \eqn{\kappa > 0}, and \eqn{x \ge 0},
has a probability density function
\deqn{(\kappa \lambda) (x \lambda) ^ {(\kappa - 1)} / (1 + (\lambda x) ^ \kappa) ^ 2.}

\item The log normal distribution
for the real-numbered mean \eqn{\mu} of the logarithm, standard deviation \eqn{\sigma > 0}
of the logarithm, and \eqn{x > 0},
has the probability density function
\deqn{1 / (x \sigma \sqrt(2 \pi)) exp(-(\log x - \mu) ^ 2 / (2 \sigma ^ 2)).}

\item The normal distribution
for the real-numbered mean \eqn{\mu}, standard deviation \eqn{\sigma > 0}, and \eqn{x} is a real number,
has the probability density function
\deqn{1 / \sqrt (2 \pi \sigma ^ 2) exp(-(x - \mu) ^ 2 / (2 \sigma ^ 2)).}

\item The uniform distribution for real-valued parameters \eqn{a} and \eqn{b} where \eqn{a < b}
and \eqn{a \le x \le b},
has the probability density function
\deqn{1 / (b - a).}

\item The Weibull distribution
for scale parameter \eqn{\lambda > 0}, shape parameter \eqn{\kappa > 0}, and \eqn{x > 0},
has the probability density function
\deqn{\kappa (\lambda ^ \kappa) x ^ {(\kappa - 1)} exp(-(\lambda x) ^ \kappa).}
}

The confidence region horizontal and vertical axis convention in use by \code{crplot} for each
distribution is:
\itemize{
\item The gamma distribution confidence region plot shows \eqn{\theta} on its horizontal axis,
and \eqn{\kappa} on its vertical axis.

\item The inverse Gaussian distribution confidence region plot shows \eqn{\mu} on its horizontal
axis, and \eqn{\lambda} on its vertical axis.

\item The log normal distribution confidence region plot shows \eqn{\mu} on its horizontal axis,
and \eqn{\sigma} on its vertical axis.

\item The log logistic distribution confidence region plot shows \eqn{\lambda} on its
horizontal axis, and \eqn{\kappa} on its vertical axis.

\item The normal distribution confidence region plot shows \eqn{\mu} on its horizontal axis, and
\eqn{\sigma} on its vertical axis.

\item The uniform distribution confidence region plot shows \eqn{a} on its horizontal axis, and
\eqn{b} on its vertical axis.

\item The Weibull distribution confidence region plot shows \eqn{\kappa} on its horizontal axis,
and \eqn{\lambda} on its vertical axis.
}
}
\examples{
## assess actual coverage at various alpha = {0.5, 0.1} given n = 30 samples,  completing
## 10 trials per parameterization (iter) for a normal(mean = 2, sd = 3) rv
coversim(alpha = c(0.5, 0.1), "norm", n = 30, iter = 10, mu = 2, sigma = 3)

## show plots for 5 iterations of 30 samples each from a Weibull(2, 3)
coversim(0.5, "weibull", n = 30, iter = 5, lambda = 1.5, kappa = 0.5, showplot = TRUE,
origin = TRUE)

}
\seealso{
\code{\link{crplot}}, \code{\link{uniroot}}
}
\author{
Christopher Weld (\email{ceweld@email.wm.edu})

Lawrence Leemis (\email{leemis@math.wm.edu})
}
\concept{
confidence region plot
}
\keyword{Estimation,}
\keyword{Graphical}
\keyword{Methods,}
\keyword{Numerical}
\keyword{Optimization}
\keyword{Parameter}
\keyword{confidence}
\keyword{coverage}
\keyword{data}
\keyword{graphics,}
\keyword{intervals,}
\keyword{region,}
\keyword{statistical}
\keyword{visualization,}
