#' Write a config list in a file (JSON/YAML/INI) 
#'
#' @param config.dat, a list of config (eg. generated by read.config)
#' @param file.path, file to write
#' @param write.type, json/ini/yaml
#' @param encoding, Encoding of filepath parameter, will default to system
#' encoding if not specifield
#' @return a list 
#' @export
#' @examples
#' list.test <- list(a=c(123,456))
#' write.config(list.test, '/tmp/test.yaml', write.type = 'yaml')
write.config <- function(config.dat, file.path, write.type = "ini", encoding = getOption("encoding")) {
  write.type <- tolower(write.type)
  if (write.type == "ini") {
    write.ini(config.dat, file.path, encoding)
  } else if (write.type == "json") {
    json.dat <- rjson::toJSON(config.dat)
    cat(toJSON(json.dat), file = file.path)
  } else if (write.type == "yaml") {
    cat(as.yaml(config.dat, indent = 2), file = file.path)
  }
}
