% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildNames.R
\name{buildNames}
\alias{buildNames}
\title{Generate Names}
\usage{
buildNames(dframe, numOfNames, minLength, maxLength)
}
\arguments{
\item{dframe}{A dataframe. This argument is passed on to another function \code{\link{genMatrix}} for generating an alphabet frequency table. This dataframe is single column dataframe with rows that contain names. These names must only contain english alphabets(upper or lower case) from A to Z.}

\item{numOfNames}{A numeric. This specifies the number of names to be generated. It should be non-zero natural number.}

\item{minLength}{A numeric. This specifies the minimum number of alphabets in the name. It must be a non-zero natural number.}

\item{maxLength}{A numeric. This specifies the maximum number of alphabets in the name. It must be a non-zero natural number.}
}
\value{
A list of names.
}
\description{
Generates names based on a given training data or using the default data
}
\details{
This function generates names. There are two options to generate names. The first option is to use an existing sample of names and generate names. The second option is to use the default table of prior probabilities.
}
\examples{
buildNames(numOfNames = 3, minLength = 5, maxLength = 7)
}
