% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{bundle_dir}
\alias{bundle_dir}
\title{Define a bundle from a Directory}
\usage{
bundle_dir(
  path = ".",
  filename = fs::file_temp(pattern = "bundle", ext = ".tar.gz")
)
}
\arguments{
\item{path}{The path to the directory to be bundled}

\item{filename}{The output bundle path}
}
\value{
Bundle A bundle object
}
\description{
Creates a bundle from a target directory.
}
\examples{
\dontshow{if (identical(Sys.getenv("IN_PKGDOWN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

bundle_dir(system.file("tests/testthat/examples/shiny/", package = "connectapi"))
\dontshow{\}) # examplesIf}
}
\seealso{
Other deployment functions: 
\code{\link{bundle_path}()},
\code{\link{bundle_static}()},
\code{\link{deploy}()},
\code{\link{download_bundle}()},
\code{\link{poll_task}()}
}
\concept{deployment functions}
