% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateHelpers.R
\name{makeItemList}
\alias{makeItemList}
\title{makeItemList}
\usage{
makeItemList(deltaDot, tau, scores = NULL)
}
\arguments{
\item{deltaDot}{a data frame or matrix of delta dots. If a data frame, column labels should be: "id", "itemid", "delta".
"itemid" should be populated with an item label or be missing for all values.
If a matrix, column order should be: "id", a unique item ID for each row; "itemid", item labels for each item (or NA); "delta", a delta dot.}

\item{tau}{a data frame or matrix of taus for polytomous items. Only polytomous items should be in this file.
If an item ID in `deltaDot` in not in `tau` it is assumed that the item is dichotomous.
Where a polytomous item has k categories, there should be k-2 rows for that item in `tau`. For example, a 3-category item has categories k_1, k_2, and k_3. There will be one value in `tau` for this item.
The tau parameters represent the deviation from the delta dot to give the item parameters for adjacent category boundaries (e.g., k_1 and k_2, and k_2 and k_3).
The value in `tau` represents the the first category boundary (e.g., k_1 and k_2). The second category boundary is constrained to be the negative sum of the other values of tau for that item.
If a data frame, column labels should be "id", "itemid", "step", "tau".
If a matrix, the column order should be: "id", a unique item ID for each item matched with values in `deltaDot`; "itemid", item labels for each item (or NA);
"step", an indicator of which step/item category this threshold represents (minimum value should be 1 and maximum value should be k-1);
"tau" the value for the tau parameter associated with this step.}

\item{scores}{a data frame of item response category scores. Not currently used - items are assumed to be scored as per the values in `tau$step`.}
}
\value{
a list.
}
\description{
creates a list of matrices. Each matrix represent item parameters of the structure used in `simplef` (a matrix of k categories by three (category score, delta dot, tau)).
}
\examples{
nItems<- 10
myItemsDeltaDot<- data.frame(
  id= seq(nItems),
  itemId= NA,
  delta = runif(nItems, -4, 1) # nItems items in range -4,1
)
myItemsTau<- data.frame(
  id = NA,
  itemId = NA,
  step = NA,
  tau = NA # this is only needed because the function is...in progress
)
myAbilities<- rnorm(100, 1, 2) # 100 person, offset from items - poor targeting (?)
myItemsList<- conquestr::makeItemList(deltaDot = myItemsDeltaDot, tau = myItemsTau)
}
