% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_region.R
\name{ms_region}
\alias{ms_region}
\title{Check if provided region is supported by Speech service}
\usage{
ms_region(region = conrad::region)
}
\arguments{
\item{region}{Subscription region for API key. For more info, see
\url{https://learn.microsoft.com/en-us/azure/cognitive-services/speech-service/regions}}
}
\value{
Character vector of region
}
\description{
If region is supported, this function returns the region. If not supported, throws a warning message.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Check if westus is supported
ms_region(region = "westus")
# Check if eastus is supported
ms_region(region = "eastus")
\dontshow{\}) # examplesIf}
}
