# # # Definition of the preCkrige-methods 
# # # Christoph Hofer, 30-03-2010

# 2023-01-25 A. Papritz formally register S3 class 'covmodel'
# 2023-12-13 A. Papritz new arguments ncores and fork for f.polygons.preCKrige 

setOldClass("covmodel")

if (!isGeneric("preCKrige"))
setGeneric(name = "preCKrige", def = function(newdata, neighbours , model, ...)
  standardGeneric("preCKrige"))
# # # 
# # # 	    
# # # 	    
preCKrige.polygonsDF <- function( 
  newdata, neighbours, model, pwidth = 0, pheight = 0, napp = 1,
  ncores = 1L, fork = !identical( .Platform[["OS.type"]], "windows" )
){#
  f.preCKrige.check.and.test( 
    newdata = newdata, neighbours = neighbours, model = model, 
    pwidth = pwidth, pheight = pheight, napp = napp,
    ncores = ncores, fork = fork
  )
  
  f.polygons.preCKrige(
    newdata = newdata, neighbours = neighbours, model = model,
    pwidth = pwidth, pheight = pheight, napp = napp, 
    ncores = ncores, fork = fork
  )
}#
setMethod(
  "preCKrige",
  c("SpatialPolygonsDataFrame", "ANY", "covmodel"), preCKrige.polygonsDF
)
# # # 
# # # 
# # # 
preCKrige.pointsDF <- function( 
  newdata, neighbours , model
){#
  
  f.preCKrige.check.and.test( 
    newdata = newdata, neighbours = neighbours, model = model
  )
  
  f.points.preCKrige( 
    newdata = newdata, neighbours = neighbours, model = model
  )
}#
setMethod(
  "preCKrige",	
  c("SpatialPointsDataFrame", "ANY", "covmodel"), preCKrige.pointsDF
)
# # # 
# # # 
# # # 
preCKrige.polygons <- function( 
  newdata, neighbours, model, pwidth = 0, pheight = 0, napp = 1,
  ncores = 1L, fork = !identical( .Platform[["OS.type"]], "windows" )
){#
  f.preCKrige.check.and.test( 
    newdata = newdata, neighbours = neighbours, model = model, 
    pwidth = pwidth, pheight = pheight, napp = napp,
    ncores = ncores, fork = fork
  )
  
  f.polygons.preCKrige( 
    newdata = newdata, neighbours = neighbours, model = model,
    pwidth = pwidth, pheight = pheight, napp = napp, 
    ncores = ncores, fork = fork
  )
}#
setMethod( 
  "preCKrige", c( "SpatialPolygons", "ANY", "covmodel"), preCKrige.polygons
)
# # # 
# # # 
# # # 
preCKrige.points  <- function( newdata, neighbours, model ){
  
  f.preCKrige.check.and.test( 
    newdata = newdata, neighbours = neighbours, model = model
  )
  
  f.points.preCKrige( 
    newdata = newdata, neighbours = neighbours, model = model 
  )
}
setMethod(
  "preCKrige",	
  c("SpatialPoints", "ANY", "covmodel"), preCKrige.points
)
