% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abort.R
\name{.cstr_combine_errors}
\alias{.cstr_combine_errors}
\title{Combine errors}
\usage{
.cstr_combine_errors(
  ...,
  class = NULL,
  call,
  header = NULL,
  body = NULL,
  footer = NULL,
  trace = NULL,
  parent = NULL,
  use_cli_format = NULL,
  .internal = FALSE,
  .file = NULL,
  .frame = parent.frame(),
  .trace_bottom = NULL
)
}
\arguments{
\item{...}{check expressions}

\item{class}{Subclass of the condition.}

\item{call}{The execution environment of a currently running
function, e.g. \code{call = caller_env()}. The corresponding function
call is retrieved and mentioned in error messages as the source
of the error.

You only need to supply \code{call} when throwing a condition from a
helper function which wouldn't be relevant to mention in the
message.

Can also be \code{NULL} or a \link[rlang:topic-defuse]{defused function call} to
respectively not display any call or hard-code a code to display.

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-call]{Including function calls in error messages}}{\link[rlang:topic-error-call]{Including function calls in error messages}}.}

\item{header}{An optional header to precede the errors}

\item{body, footer}{Additional bullets.}

\item{trace}{A \code{trace} object created by \code{\link[rlang:trace_back]{trace_back()}}.}

\item{parent}{Supply \code{parent} when you rethrow an error from a
condition handler (e.g. with \code{\link[rlang:try_fetch]{try_fetch()}}).
\itemize{
\item If \code{parent} is a condition object, a \emph{chained error} is
created, which is useful when you want to enhance an error with
more details, while still retaining the original information.
\item If \code{parent} is \code{NA}, it indicates an unchained rethrow, which
is useful when you want to take ownership over an error and
rethrow it with a custom message that better fits the
surrounding context.

Technically, supplying \code{NA} lets \code{abort()} know it is called
from a condition handler. This helps it create simpler
backtraces where the condition handling context is hidden by
default.
}

For more information about error calls, see \ifelse{html}{\link[rlang:topic-error-chaining]{Including contextual information with error chains}}{\link[rlang:topic-error-chaining]{Including contextual information with error chains}}.}

\item{use_cli_format}{Whether to format \code{message} lazily using
\href{https://cli.r-lib.org/}{cli} if available. This results in
prettier and more accurate formatting of messages. See
\code{\link[rlang:local_use_cli]{local_use_cli()}} to set this condition field by default in your
package namespace.

If set to \code{TRUE}, \code{message} should be a character vector of
individual and unformatted lines. Any newline character \code{"\\\n"}
already present in \code{message} is reformatted by cli's paragraph
formatter. See \ifelse{html}{\link[rlang:topic-condition-formatting]{Formatting messages with cli}}{\link[rlang:topic-condition-formatting]{Formatting messages with cli}}.}

\item{.internal}{If \code{TRUE}, a footer bullet is added to \code{message}
to let the user know that the error is internal and that they
should report it to the package authors. This argument is
incompatible with \code{footer}.}

\item{.file}{A connection or a string specifying where to print the
message. The default depends on the context, see the \code{stdout} vs
\code{stderr} section.}

\item{.frame}{The throwing context. Used as default for
\code{.trace_bottom}, and to determine the internal package to mention
in internal errors when \code{.internal} is \code{TRUE}.}

\item{.trace_bottom}{Used in the display of simplified backtraces
as the last relevant call frame to show. This way, the irrelevant
parts of backtraces corresponding to condition handling
(\code{\link[=tryCatch]{tryCatch()}}, \code{\link[rlang:try_fetch]{try_fetch()}}, \code{abort()}, etc.) are hidden by
default. Defaults to \code{call} if it is an environment, or \code{.frame}
otherwise. Without effect if \code{trace} is supplied.}
}
\value{
Returns \code{NULL} invisibly, called for side effects.
}
\description{
Exported for custom constructor design. This function allows combining independent checks so information is given about
all failing checks rather than the first one. All parameters except \code{...} are
forwarded to \code{rlang::abort()}
}
