% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findDistThresh.R
\name{findDistThresh}
\alias{findDistThresh}
\title{Identify Point-Based Distance Threshold for Contact}
\usage{
findDistThresh(
  n = 1000,
  acc.Dist1 = 0.5,
  acc.Dist2 = NULL,
  pWithin1 = 90,
  pWithin2 = NULL,
  spTh = 0.666
)
}
\arguments{
\item{n}{Integer. Number of "in-contact" point-pairs used in the 
expected-distance distribution(s). Defaults to 1000.}

\item{acc.Dist1}{Numerical. Accuracy distance for point 1.}

\item{acc.Dist2}{Numerical. Accuracy distance for point 2. If == NULL, 
defaults to acc.Dist1 value.}

\item{pWithin1}{Numerical. Percentage of data points within acc.Dist of true
locations for point 1.}

\item{pWithin2}{Numerical. Percentage of data points within acc.Dist of true
locations for point 2. If == NULL, defaults to pWithin1 value.}

\item{spTh}{Numerical. Pre-determined distance representing biological 
threshold for contact.}
}
\value{
Output is a list containing 5 named vectors. The first vector 
   describes summary statistics of the simulated distance distribution. The
   second and third vectors describes varied confidence intervals (50-99%)
   for the simulated distribiution. The fourth vector describes adjusted 
   spTh values that will capture approximately 84, 98, and 100% of true 
   contacts given the pre-determined spTh value (all calculated using the 
   Empirical rule). Finally, the fifth vector describes the actial observed 
   frequency of captured true contact given the spTh adjustments listed in 
   the fourth vector.
}
\description{
Sample from a multivariate normal distribution to create "in-contact" n 
   point pairs based on real-time-location systems accuracy, and 
   generate a distribution describing observed distances between point
   pairs.
}
\details{
This function is for adjusting contact-distance thresholds (spTh) to account
   for positional accuracy of real-time-location systems, assuming random 
   (non-biased) error in location-fix positions relative to true locations. 
   Essentially this function can be used to determine an adjusted spTh value
   that likely includes the majority of true contacts defined using the 
   initial spTh.
}
\examples{
findDistThresh(n = 10,  acc.Dist1 = 0.5, acc.Dist2 = NULL, 
   pWithin1 = 90, pWithin2 = NULL, spTh = 0.5) 

}
\references{
Farthing, T.S., Dawson, D.E., Sanderson, M.W., and Lanzas, 
   C. 2020. Accounting for space and uncertainty in real-time-location-
   system-derived contact networks. Ecology and Evolution 10(11):4702-4715.
}
\keyword{contact}
\keyword{location}
\keyword{point}
