% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0-dict.table.R, R/add.R, R/at.R,
%   R/at2.R, R/clear.R, R/clone.R, R/delete_at.R, R/discard_at.R, R/has.R,
%   R/has_name.R, R/is_empty.R, R/peek_at.R, R/peek_at2.R, R/pop.R, R/rename.R,
%   R/replace_at.R, R/update.R
\name{dict.table}
\alias{dict.table}
\alias{as.dict.table}
\alias{as.dict.table.data.table}
\alias{is.dict.table}
\alias{rbind.dict.table}
\alias{cbind.dict.table}
\title{Combining Dict and data.table}
\usage{
dict.table(...)

as.dict.table(x, ...)

\method{as.dict.table}{data.table}(x, copy = TRUE, ...)

is.dict.table(x)

\method{rbind}{dict.table}(x, ...)

\method{cbind}{dict.table}(x, ...)
}
\arguments{
\item{...}{elements put into the \link{dict.table} and/or additional
arguments to be passed on.}

\item{x}{any \code{R} object or a \link{dict.table} object.}

\item{copy}{if \code{TRUE} creates a copy of the \link{data.table} object otherwise
works on the passed object by reference.}
}
\description{
The \link{dict.table} is a combination of \link{dict} and
\href{https://CRAN.R-project.org/package=data.table}{data.table}
and basically can be considered a
\href{https://CRAN.R-project.org/package=data.table}{data.table}
with unique
column names and an extended set of functions to add, extract and
remove data columns with the goal to further facilitate code development
using \href{https://CRAN.R-project.org/package=data.table}{data.table}.
A \link{dict.table} object provides all \link{dict} and
\href{https://CRAN.R-project.org/package=data.table}{data.table}
functions and operators at the same time.
}
\details{
Methods that alter \link{dict.table} objects usually come in two versions
providing either copy or reference semantics where the latter start with
\code{'ref_'} to note the reference semantic, for example, \code{\link[=add]{add()}} and \code{\link[=ref_add]{ref_add()}}.

\itemize{
\item \code{dict.table(...)} initializes and returns a \link{dict} object.
}

\itemize{
\item \code{as.dict.table(x, ...)} coerce \code{x} to a \link{dict.table}
}

\itemize{
\item \code{is.dict.table(x)} check if \code{x} is a \code{dict.table}
}

\itemize{
\item \code{add(.x, ...)} and \code{ref_add(.x, ...)} add columns to \code{.x}. If the column name
already exists, an error is given.
}

\itemize{
\item \code{at(.x, ...)} returns the columns at the given indices. Indices
can be letters or numbers or both. All columns must exist.
}

\itemize{
\item \code{at2(x, index)} returns the column at the given \code{index} or signals
an error if not found.
}

\itemize{
\item \code{clear(x)} and \code{ref_clear(x)} remove all elements from \code{x}.
}

\itemize{
\item \code{clone(x)} create a copy of \code{x}.
}

\itemize{
\item \code{delete_at(.x, ...)} and \code{ref_delete_at(.x, ...)} find and remove columns either by
name or index (or both). If one or more columns don't exist, an error is signaled.
}

\itemize{
\item \code{discard_at(.x, ...)} and \code{ref_discard_at(.x, ...)} find and remove columns
either by name or index (or both). Invalid column indices are ignored.
}

\itemize{
\item \code{has(x, column)} check if some \code{column} is in dict.table object.
}

\itemize{
\item \code{has_name(x, name)} check if \code{x} has the given column name.
}

\itemize{
\item \code{is_empty(x)} \code{TRUE} if object is empty otherwise \code{FALSE}
}

\itemize{
\item \code{peek_at(x, ..., .default = NULL)} returns the columns at the given
indices or (if not found) columns with the given default value.
}

\itemize{
\item \code{peek_at2(x, index, default = NULL)} return column named \code{index} if it exist
otherwise the given \code{default} value. If the default length does not match
the number of rows, it is recycled accordingly and a warning is given,
unless the default value has a length of 1, in which case recycling is
done silently.
}

\itemize{
\item \code{ref_pop(.x, index)} return element at given column index and remove the
column from the dict.table object.
}

\itemize{
\item \code{rename(.x, old, new)} and \code{ref_rename(.x, old, new)} rename one or more
columns from \code{old} to \code{new}, respectively, by copy and in place (i.e. by
reference).
}

\itemize{
\item \code{replace_at(.x, .., .add = FALSE)} and \code{ref_replace_at(.x, ..., .add = FALSE)}
replace values at given indices. If a given index is invalid, an error is
signaled unless \code{.add} was set to \code{TRUE}.
}

\itemize{
\item \code{update(object, other)} and \code{ref_update(object, other)} adds columns of \code{other} dict
that are not yet in \code{object} and replaces the values at existing columns.
}
}
\examples{
# Some basic examples using some typical data.table and dict operations.
# The constructor can take the 'key' argument known from data.table():
require(data.table)
dit = dict.table(x = rep(c("b","a","c"), each = 3), y = c(1,3,6), key = "y")
print(dit)
setkey(dit, "x")                             # sort by 'x'
print(dit)
(add(dit, "v" = 1:9))                        # add column v = 1:9
dit[y > 5]
(ref_discard_at(dit, "x"))                   # discard column 'x'

try(at(dit, "x"))                            # index 'x' not found
try(replace_at(dit, x = 0))                  # cannot be replaced, if it does not exist

dit = replace_at(dit, x = 0, .add = TRUE)    # ok - re-adds column 'x' with all 0s
peek_at(dit, "x")                            # glance at column 'x'
has_name(dit, "x")                           # TRUE
ref_pop(dit, "x")                            # get column and remove it
has_name(dit, "x")                           # FALSE


# Copy and reference semantics when coercing *from* a data.table
dat = data.table(a = 1, b = 2)
dit = as.dict.table(dat)
is.dict.table(dit)                           # TRUE
is.dict.table(dat)                           # FALSE
ref_replace_at(dit, "a", 9)
dit[["a"]]                                   # 9
dat[["a"]]                                   # 1
dit.dat = as.dict.table(dat, copy = FALSE)   # init by reference
ref_replace_at(dit.dat, "a", 9)
dat[["a"]]                                   # 9
is.dict.table(dit.dat)                       # TRUE
is.dict.table(dat)                           # TRUE now as well!

# Coerce from dict
d = dict(a = 1, b = 1:3)
as.dict.table(d)

dit = dict.table(a = 1:2, b = 1:2)
rbind(dit, dit)

# rbind ...
dit = dict.table(a = 1:2, b = 1:2)
rbind(dit, dit)

# ... can be mixed with data.tables
dat = data.table(a = 3:4, b = 3:4)
rbind(dit, dat)  # yields a dict.table
rbind(dat, dit)  # yields a data.table

# cbind ...
dit = dict.table(a = 1:2, b = 1:2)
dit2 = dict.table(c = 3:4, d = 5:6)
cbind(dit, dit2)

# ... can be mixed with data.tables
dat = data.table(x = 3:4, y = 3:4)
cbind(dit, dat)

dit = dict.table(a = 1:3)
add(dit, b = 3:1, d = 4:6)

try(add(dit, a = 7:9))  # column 'a' already exists

dit = dict.table(a = 1:3, b = 4:6)
at(dit, "a")
at(dit, 2)
at(dit, "a", 2)
try(at(dit, "x"))     # index 'x' not found
try(at(dit, 1:3))     # index 3 exceeds length of dict.table

dit = dict.table(a = 1:3, b = 4:6)
at2(dit, 1)
at2(dit, "a")
at2(dit, 2)
try(at2(dit, "x"))     # index 'x' not found
try(at2(dit, 5))       # index 5 exceeds length of dict.table

dit = dict.table(a = 1, b = 2)
clear(dit)
dit
ref_clear(dit)
dit

d = dict.table(a = 1:2, b = 3:4)
d2 = clone(d)
ref_clear(d)
print(d2)

(dit = as.dict.table(head(sleep)))
delete_at(dit, "ID")
delete_at(dit, "ID", 1)

try({
delete_at(dit, "foo")   # Column 'foo' not in dict.table
})

dit = as.dict.table(head(sleep))
discard_at(dit, "ID")
discard_at(dit, "ID", 1)
discard_at(dit, "foo")  # ignored

dit = dict.table(a = 1:3, b = as.list(4:6))
has(dit, 1:3)            # TRUE
has(dit, 4:6)            # FALSE
has(dit, as.list(4:6))   # TRUE

dit = dict.table(a = 1, b = 2)
has_name(dit, "a")    # TRUE
has_name(dit, "x")    # FALSE

d = dict.table(a = 1:4, b = 4:1)
is_empty(d)
is_empty(clear(d))

dit = dict.table(a = 1:3, b = 4:6)
peek_at(dit, "a")
peek_at(dit, 1)
peek_at(dit, 3)
peek_at(dit, "x")
peek_at(dit, "x", .default = 0)
peek_at(dit, "a", "x", .default = 0)

dit = dict.table(a = 1:3, b = 4:6)
peek_at2(dit, "a")
peek_at2(dit, 1)
peek_at2(dit, 3)
peek_at2(dit, 3, default = 9)
peek_at2(dit, "x")
peek_at2(dit, "x", default = 0)

dit = dict.table(a = 1:3, b = 4:6)
ref_pop(dit, "a")
ref_pop(dit, 1)

try({
ref_pop(dit, "x")  # index 'x' not found
})

dit = dict.table(a = 1, b = 2, c = 3)
rename(dit, c("a", "b"), c("a1", "y"))
print(dit)
ref_rename(dit, c("a", "b"), c("a1", "y"))
print(dit)

dit = dict.table(a = 1:3)
replace_at(dit, "a", 3:1)

try({
replace_at(dit, "b", 4:6)               # column 'b' not in dict.table
})
replace_at(dit, "b", 4:6, .add = TRUE)  # ok, adds column

# Update parts of tables (second overwrites columns of the first)
dit1 = dict.table(a = 1:2, b = 3:4)
dit2 = dict.table(         b = 5:6, c = 8:9)
update(dit1, dit2)
update(dit2, dit1)
}
\seealso{
\link{dict}, \href{https://CRAN.R-project.org/package=data.table}{data.table}
}
