% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probMat.R
\name{[.tables}
\alias{[.tables}
\title{Subset object of class tables}
\usage{
\method{[}{tables}(x, i, j, ..., drop = TRUE, keep = FALSE)
}
\arguments{
\item{x}{object of class \code{tables}}

\item{i}{indicies of which tables to retain}

\item{j}{which rows of each table to retain (or if \code{...} not specified, entries )}

\item{...}{additional indices up to the dimension of the table}

\item{drop}{usual logical indicating whether to consolidate margins of the table (doesn't apply to \code{i})}

\item{keep}{if only one table is specified with \code{i}, should the object output be an object of class \code{tables}?  If not becomes a suitable array.}
}
\value{
A tables object over the specific entries and values selected.
}
\description{
Take subset of tables class.
}
\details{
There are two main ways to subset these tables.  In both cases the first index 
refers to the tables being selected; one of the methods is to additionally specify all the 
indices corresponding to the tables, the other is to only specify a single entry.  
For example, \code{x[,1,2,2]} specifies the (1,2,2)th entry of each table; \code{x[,7]} will
have the same effect for 2x2x2 tables.

If only one index is specified, then the function behaves just as ordinary subsetting
on an array.
}
\examples{
x <- rprobMat(n=10, rep(2,3))
x[1,]
x[,1,1:2,1]
x[,1,1:2,1,drop=FALSE]

}
