% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trend_estimate_CI_tests_rx2.R
\name{Trend_estimate_CI_tests_rx2}
\alias{Trend_estimate_CI_tests_rx2}
\title{Trend estimate for linear and logit models}
\usage{
Trend_estimate_CI_tests_rx2(
  n,
  a = seq_len(nrow(n)),
  linkfunction = "logit",
  alpha = 0.05
)
}
\arguments{
\item{n}{the observed counts (an rx2 matrix)}

\item{a}{scores assigned to the rows}

\item{linkfunction}{Link function for the binomial distribution see
\code{?family} for more details}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
Trend estimate for linear and logit models
\itemize{
\item The Wald test and CI
\item Likelihood ratio test
\item The Pearson goodness-of-fit test
\item Likelihood ratio (deviance) goodness-of-fit test
}

Described in Chapter 5 "The Ordered rx2 Table"
}
\examples{
# Alcohol consumption and malformations (Mills and Graubard, 1987)
Trend_estimate_CI_tests_rx2(mills_graubard_1987, 1:5)

# levated troponin T levels in stroke patients (Indredavik et al., 2008)
Trend_estimate_CI_tests_rx2(indredavik_2008, 1:5)
}
