% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/convexHull.R
\name{getConvexHull}
\alias{getConvexHull}
\title{Get Convex Hull of Points}
\usage{
getConvexHull(x, y, closeHull = TRUE)
}
\arguments{
\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values of same length as x}

\item{closeHull}{whether to close the hull or not, by closed, meaning that the last index in the hull ix exactly the
same as the first index}
}
\description{
Returns the sequence of indexes from supplied points x and y, that describe the convex hull of those points.
With the exception of a few brief checks, is almost a direct wrapper to the \code{\link[geometry]{convhulln}}
function as part of the geometry package.
}
\examples{
#Generate the Convex Hull of a Series of Points
set.seed(1)
x  = runif(100)
y  = runif(100)
ch = getConvexHull(x,y,closeHull=TRUE)

#To demonstrate, Lets view the hull
library(ggplot2)
df = data.frame(x,y)
ggplot(data=df,aes(x,y)) +
   geom_path(data=df[ch,]) +
   geom_point()
}

